/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import java.util.UUID;
import java.util.function.BiConsumer;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public interface UaEncoder {
    public void encodeBoolean(String var1, Boolean var2) throws UaSerializationException;

    public void encodeSByte(String var1, Byte var2) throws UaSerializationException;

    public void encodeInt16(String var1, Short var2) throws UaSerializationException;

    public void encodeInt32(String var1, Integer var2) throws UaSerializationException;

    public void encodeInt64(String var1, Long var2) throws UaSerializationException;

    public void encodeByte(String var1, UByte var2) throws UaSerializationException;

    public void encodeUInt16(String var1, UShort var2) throws UaSerializationException;

    public void encodeUInt32(String var1, UInteger var2) throws UaSerializationException;

    public void encodeUInt64(String var1, ULong var2) throws UaSerializationException;

    public void encodeFloat(String var1, Float var2) throws UaSerializationException;

    public void encodeDouble(String var1, Double var2) throws UaSerializationException;

    public void encodeString(String var1, String var2) throws UaSerializationException;

    public void encodeDateTime(String var1, DateTime var2) throws UaSerializationException;

    public void encodeGuid(String var1, UUID var2) throws UaSerializationException;

    public void encodeByteString(String var1, ByteString var2) throws UaSerializationException;

    public void encodeXmlElement(String var1, XmlElement var2) throws UaSerializationException;

    public void encodeNodeId(String var1, NodeId var2) throws UaSerializationException;

    public void encodeExpandedNodeId(String var1, ExpandedNodeId var2) throws UaSerializationException;

    public void encodeStatusCode(String var1, StatusCode var2) throws UaSerializationException;

    public void encodeQualifiedName(String var1, QualifiedName var2) throws UaSerializationException;

    public void encodeLocalizedText(String var1, LocalizedText var2) throws UaSerializationException;

    public void encodeExtensionObject(String var1, ExtensionObject var2) throws UaSerializationException;

    public void encodeDataValue(String var1, DataValue var2) throws UaSerializationException;

    public void encodeVariant(String var1, Variant var2) throws UaSerializationException;

    public void encodeDiagnosticInfo(String var1, DiagnosticInfo var2) throws UaSerializationException;

    public <T extends UaStructure> void encodeMessage(String var1, T var2) throws UaSerializationException;

    public <T extends UaEnumeration> void encodeEnumeration(String var1, T var2) throws UaSerializationException;

    public <T extends UaSerializable> void encodeSerializable(String var1, T var2) throws UaSerializationException;

    public <T> void encodeArray(String var1, T[] var2, BiConsumer<String, T> var3) throws UaSerializationException;
}

