/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaSerializable;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public interface UaDecoder {
    public Boolean decodeBoolean(String var1) throws UaSerializationException;

    public Byte decodeSByte(String var1) throws UaSerializationException;

    public Short decodeInt16(String var1) throws UaSerializationException;

    public Integer decodeInt32(String var1) throws UaSerializationException;

    public Long decodeInt64(String var1) throws UaSerializationException;

    public UByte decodeByte(String var1) throws UaSerializationException;

    public UShort decodeUInt16(String var1) throws UaSerializationException;

    public UInteger decodeUInt32(String var1) throws UaSerializationException;

    public ULong decodeUInt64(String var1) throws UaSerializationException;

    public Float decodeFloat(String var1) throws UaSerializationException;

    public Double decodeDouble(String var1) throws UaSerializationException;

    public String decodeString(String var1) throws UaSerializationException;

    public DateTime decodeDateTime(String var1) throws UaSerializationException;

    public UUID decodeGuid(String var1) throws UaSerializationException;

    public ByteString decodeByteString(String var1) throws UaSerializationException;

    public XmlElement decodeXmlElement(String var1) throws UaSerializationException;

    public NodeId decodeNodeId(String var1) throws UaSerializationException;

    public ExpandedNodeId decodeExpandedNodeId(String var1) throws UaSerializationException;

    public StatusCode decodeStatusCode(String var1) throws UaSerializationException;

    public QualifiedName decodeQualifiedName(String var1) throws UaSerializationException;

    public LocalizedText decodeLocalizedText(String var1) throws UaSerializationException;

    public ExtensionObject decodeExtensionObject(String var1) throws UaSerializationException;

    public DataValue decodeDataValue(String var1) throws UaSerializationException;

    public Variant decodeVariant(String var1) throws UaSerializationException;

    public DiagnosticInfo decodeDiagnosticInfo(String var1) throws UaSerializationException;

    public <T extends UaStructure> T decodeMessage(String var1) throws UaSerializationException;

    public <T extends UaEnumeration> T decodeEnumeration(String var1, Class<T> var2) throws UaSerializationException;

    public <T extends UaSerializable> T decodeSerializable(String var1, Class<T> var2) throws UaSerializationException;

    public <T> T[] decodeArray(String var1, Function<String, T> var2, Class<T> var3) throws UaSerializationException;

    public <T> T[] decodeArray(String var1, BiFunction<String, Class<T>, T> var2, Class<T> var3) throws UaSerializationException;
}

