/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteOrder;
import javax.xml.stream.XMLStreamException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.serialization.DecoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.EncoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.xml.XmlDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.xml.XmlEncoder;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;

public class OpcUaDataTypeEncoding
implements DataTypeEncoding {
    private static final DelegateRegistry.Instance DELEGATE_REGISTRY = DelegateRegistry.getInstance();
    private final ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;

    @Override
    public ByteString encodeToByteString(Object object, NodeId encodingTypeId) {
        EncoderDelegate<Object> delegate = DELEGATE_REGISTRY.getEncoder(encodingTypeId);
        ByteBuf buffer = this.allocator.buffer().order(ByteOrder.LITTLE_ENDIAN);
        BinaryEncoder encoder = new BinaryEncoder();
        encoder.setBuffer(buffer);
        delegate.encode(object, encoder);
        byte[] bs = new byte[buffer.readableBytes()];
        buffer.readBytes(bs);
        buffer.release();
        return ByteString.of(bs);
    }

    @Override
    public Object decodeFromByteString(ByteString encoded, NodeId encodingTypeId) {
        DecoderDelegate delegate = DELEGATE_REGISTRY.getDecoder(encodingTypeId);
        byte[] bs = encoded.bytes();
        if (bs == null) {
            bs = new byte[]{};
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bs).order(ByteOrder.LITTLE_ENDIAN);
        BinaryDecoder decoder = new BinaryDecoder();
        decoder.setBuffer(buffer);
        return delegate.decode(decoder);
    }

    @Override
    public XmlElement encodeToXmlElement(Object object, NodeId encodingTypeId) {
        try {
            EncoderDelegate<Object> delegate = DELEGATE_REGISTRY.getEncoder(encodingTypeId);
            StringWriter stringWriter = new StringWriter();
            XmlEncoder encoder = new XmlEncoder();
            encoder.setOutput(stringWriter);
            delegate.encode(object, encoder);
            return new XmlElement(stringWriter.toString());
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80060000L, (Throwable)e);
        }
    }

    @Override
    public Object decodeFromXmlElement(XmlElement encoded, NodeId encodingTypeId) {
        try {
            DecoderDelegate delegate = DELEGATE_REGISTRY.getDecoder(encodingTypeId);
            XmlDecoder decoder = new XmlDecoder();
            decoder.setInput(new StringReader(encoded.getFragment()));
            return delegate.decode(decoder);
        }
        catch (XMLStreamException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }
}

