/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DecoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistryInitializer;
import org.eclipse.milo.opcua.stack.core.serialization.EncoderDelegate;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class DelegateRegistry {
    private static final Map<Class<?>, EncoderDelegate<?>> ENCODERS_BY_CLASS = Maps.newConcurrentMap();
    private static final Map<NodeId, EncoderDelegate<?>> ENCODERS_BY_ID = Maps.newConcurrentMap();
    private static final Map<Class<?>, DecoderDelegate<?>> DECODERS_BY_CLASS = Maps.newConcurrentMap();
    private static final Map<NodeId, DecoderDelegate<?>> DECODERS_BY_ID = Maps.newConcurrentMap();
    private static final AtomicReference<Instance> INSTANCE_REF = new AtomicReference();

    public static Instance getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static synchronized Instance getOrInitialize() {
        Instance instance = INSTANCE_REF.get();
        if (instance == null) {
            DelegateRegistryInitializer.initialize();
            instance = new Instance(ENCODERS_BY_CLASS, ENCODERS_BY_ID, DECODERS_BY_CLASS, DECODERS_BY_ID);
            INSTANCE_REF.set(instance);
            return instance;
        }
        return instance;
    }

    public static synchronized <T> void register(EncoderDelegate<T> encoder, DecoderDelegate<T> decoder, Class<T> clazz, NodeId ... ids) {
        DelegateRegistry.registerEncoder(encoder, clazz, ids);
        DelegateRegistry.registerDecoder(decoder, clazz, ids);
    }

    public static synchronized <T> void registerEncoder(EncoderDelegate<T> delegate, Class<T> clazz, NodeId ... ids) {
        ENCODERS_BY_CLASS.put(clazz, delegate);
        if (ids != null) {
            Arrays.stream(ids).forEach(id -> ENCODERS_BY_ID.put((NodeId)id, delegate));
        }
    }

    public static synchronized <T> void registerDecoder(DecoderDelegate<T> delegate, Class<T> clazz, NodeId ... ids) {
        DECODERS_BY_CLASS.put(clazz, delegate);
        if (ids != null) {
            Arrays.stream(ids).forEach(id -> DECODERS_BY_ID.put((NodeId)id, delegate));
        }
    }

    static /* synthetic */ Instance access$100() {
        return DelegateRegistry.getOrInitialize();
    }

    public static class Instance {
        private final Map<Class<?>, EncoderDelegate<?>> encodersByClass;
        private final Map<NodeId, EncoderDelegate<?>> encodersById;
        private final Map<Class<?>, DecoderDelegate<?>> decodersByClass;
        private final Map<NodeId, DecoderDelegate<?>> decodersById;

        private Instance(Map<Class<?>, EncoderDelegate<?>> encodersByClass, Map<NodeId, EncoderDelegate<?>> encodersById, Map<Class<?>, DecoderDelegate<?>> decodersByClass, Map<NodeId, DecoderDelegate<?>> decodersById) {
            this.encodersByClass = encodersByClass;
            this.encodersById = encodersById;
            this.decodersByClass = decodersByClass;
            this.decodersById = decodersById;
        }

        public <T> EncoderDelegate<T> getEncoder(Object t) throws UaSerializationException {
            try {
                return this.encodersByClass.get(t.getClass());
            }
            catch (NullPointerException e) {
                throw new UaSerializationException(0x80060000L, "no encoder registered for class=" + t);
            }
        }

        public <T> EncoderDelegate<T> getEncoder(Class<?> clazz) throws UaSerializationException {
            EncoderDelegate<?> encoderDelegate = this.encodersByClass.get(clazz);
            if (encoderDelegate != null) {
                try {
                    return encoderDelegate;
                }
                catch (Exception e) {
                    throw new UaSerializationException(0x80060000L, (Throwable)e);
                }
            }
            throw new UaSerializationException(0x80060000L, "no encoder registered for class=" + clazz);
        }

        public <T> EncoderDelegate<T> getEncoder(NodeId encodingId) throws UaSerializationException {
            EncoderDelegate<?> encoderDelegate = this.encodersById.get(encodingId);
            if (encoderDelegate != null) {
                try {
                    return encoderDelegate;
                }
                catch (Exception e) {
                    throw new UaSerializationException(0x80060000L, (Throwable)e);
                }
            }
            throw new UaSerializationException(0x80060000L, "no encoder registered for encodingId=" + encodingId);
        }

        public <T> DecoderDelegate<T> getDecoder(T t) throws UaSerializationException {
            try {
                return this.decodersByClass.get(t.getClass());
            }
            catch (NullPointerException e) {
                throw new UaSerializationException(0x80070000L, "no decoder registered for class=" + t);
            }
        }

        public <T> DecoderDelegate<T> getDecoder(Class<T> clazz) throws UaSerializationException {
            DecoderDelegate<?> decoderDelegate = this.decodersByClass.get(clazz);
            if (decoderDelegate != null) {
                try {
                    return decoderDelegate;
                }
                catch (Exception e) {
                    throw new UaSerializationException(0x80070000L, (Throwable)e);
                }
            }
            throw new UaSerializationException(0x80070000L, "no decoder registered for class=" + clazz);
        }

        public <T> DecoderDelegate<T> getDecoder(NodeId encodingId) {
            DecoderDelegate<?> decoderDelegate = this.decodersById.get(encodingId);
            if (decoderDelegate != null) {
                try {
                    return decoderDelegate;
                }
                catch (Exception e) {
                    throw new UaSerializationException(0x80070000L, (Throwable)e);
                }
            }
            throw new UaSerializationException(0x80070000L, "no decoder registered for encodingId=" + encodingId);
        }
    }

    private static class InstanceHolder {
        private static final Instance INSTANCE = DelegateRegistry.access$100();

        private InstanceHolder() {
        }
    }
}

