/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;

public class ExceptionHandler {
    public static ErrorMessage sendErrorMessage(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String message = cause.getMessage();
        long statusCode = 0x80010000L;
        if (cause instanceof UaException) {
            UaException ex = (UaException)cause;
            message = ex.getMessage();
            statusCode = ex.getStatusCode().getValue();
        } else {
            Exception ex;
            Throwable innerCause = cause.getCause();
            if (innerCause instanceof UaException) {
                ex = (UaException)innerCause;
                message = ((UaException)ex).getMessage();
                statusCode = ((UaException)ex).getStatusCode().getValue();
            } else if (innerCause instanceof UaRuntimeException) {
                ex = (UaRuntimeException)innerCause;
                message = ex.getMessage();
                statusCode = ((UaRuntimeException)ex).getStatusCode();
            }
        }
        ErrorMessage error = new ErrorMessage(statusCode, message);
        ByteBuf messageBuffer = TcpMessageEncoder.encode(error);
        ctx.writeAndFlush((Object)messageBuffer).addListener(future -> ctx.close());
        return error;
    }
}

