/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.DiscoveryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.QueryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequestHandler;
import org.eclipse.milo.opcua.stack.core.application.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.TestServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServerRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.TestStackExRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TestStackRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public interface UaStackServer {
    public CompletableFuture<? extends UaStackServer> startup();

    public CompletableFuture<? extends UaStackServer> shutdown();

    public CertificateManager getCertificateManager();

    public CertificateValidator getCertificateValidator();

    public ChannelConfig getChannelConfig();

    public ExecutorService getExecutorService();

    public EndpointDescription[] getEndpointDescriptions();

    public List<UserTokenPolicy> getUserTokenPolicies();

    public ApplicationDescription getApplicationDescription();

    public SignedSoftwareCertificate[] getSoftwareCertificates();

    public ServerSecureChannel openSecureChannel();

    public CompletableFuture<Unit> closeSecureChannel(ServerSecureChannel var1);

    public <T extends UaRequestMessage, U extends UaResponseMessage> void addRequestHandler(Class<T> var1, ServiceRequestHandler<T, U> var2);

    public UaStackServer addEndpoint(String var1, String var2, X509Certificate var3, SecurityPolicy var4, MessageSecurityMode var5);

    default public UaStackServer addEndpoint(String endpointUri, String bindAddress) {
        return this.addEndpoint(endpointUri, bindAddress, null, SecurityPolicy.None, MessageSecurityMode.None);
    }

    default public void addServiceSet(AttributeServiceSet serviceSet) {
        this.addRequestHandler(ReadRequest.class, serviceSet::onRead);
        this.addRequestHandler(WriteRequest.class, serviceSet::onWrite);
        this.addRequestHandler(HistoryReadRequest.class, serviceSet::onHistoryRead);
        this.addRequestHandler(HistoryUpdateRequest.class, serviceSet::onHistoryUpdate);
    }

    default public void addServiceSet(DiscoveryServiceSet serviceSet) {
        this.addRequestHandler(GetEndpointsRequest.class, serviceSet::onGetEndpoints);
        this.addRequestHandler(FindServersRequest.class, serviceSet::onFindServers);
        this.addRequestHandler(RegisterServerRequest.class, serviceSet::onRegisterServer);
    }

    default public void addServiceSet(QueryServiceSet serviceSet) {
        this.addRequestHandler(QueryFirstRequest.class, serviceSet::onQueryFirst);
        this.addRequestHandler(QueryNextRequest.class, serviceSet::onQueryNext);
    }

    default public void addServiceSet(MethodServiceSet serviceSet) {
        this.addRequestHandler(CallRequest.class, serviceSet::onCall);
    }

    default public void addServiceSet(MonitoredItemServiceSet serviceSet) {
        this.addRequestHandler(CreateMonitoredItemsRequest.class, serviceSet::onCreateMonitoredItems);
        this.addRequestHandler(ModifyMonitoredItemsRequest.class, serviceSet::onModifyMonitoredItems);
        this.addRequestHandler(DeleteMonitoredItemsRequest.class, serviceSet::onDeleteMonitoredItems);
        this.addRequestHandler(SetMonitoringModeRequest.class, serviceSet::onSetMonitoringMode);
        this.addRequestHandler(SetTriggeringRequest.class, serviceSet::onSetTriggering);
    }

    default public void addServiceSet(NodeManagementServiceSet serviceSet) {
        this.addRequestHandler(AddNodesRequest.class, serviceSet::onAddNodes);
        this.addRequestHandler(DeleteNodesRequest.class, serviceSet::onDeleteNodes);
        this.addRequestHandler(AddReferencesRequest.class, serviceSet::onAddReferences);
        this.addRequestHandler(DeleteReferencesRequest.class, serviceSet::onDeleteReferences);
    }

    default public void addServiceSet(SessionServiceSet serviceSet) {
        this.addRequestHandler(CreateSessionRequest.class, serviceSet::onCreateSession);
        this.addRequestHandler(ActivateSessionRequest.class, serviceSet::onActivateSession);
        this.addRequestHandler(CloseSessionRequest.class, serviceSet::onCloseSession);
        this.addRequestHandler(CancelRequest.class, serviceSet::onCancel);
    }

    default public void addServiceSet(SubscriptionServiceSet serviceSet) {
        this.addRequestHandler(CreateSubscriptionRequest.class, serviceSet::onCreateSubscription);
        this.addRequestHandler(ModifySubscriptionRequest.class, serviceSet::onModifySubscription);
        this.addRequestHandler(DeleteSubscriptionsRequest.class, serviceSet::onDeleteSubscriptions);
        this.addRequestHandler(TransferSubscriptionsRequest.class, serviceSet::onTransferSubscriptions);
        this.addRequestHandler(SetPublishingModeRequest.class, serviceSet::onSetPublishingMode);
        this.addRequestHandler(PublishRequest.class, serviceSet::onPublish);
        this.addRequestHandler(RepublishRequest.class, serviceSet::onRepublish);
    }

    default public void addServiceSet(TestServiceSet serviceSet) {
        this.addRequestHandler(TestStackRequest.class, serviceSet::onTestStack);
        this.addRequestHandler(TestStackExRequest.class, serviceSet::onTestStackEx);
    }

    default public void addServiceSet(ViewServiceSet serviceSet) {
        this.addRequestHandler(BrowseRequest.class, serviceSet::onBrowse);
        this.addRequestHandler(BrowseNextRequest.class, serviceSet::onBrowseNext);
        this.addRequestHandler(TranslateBrowsePathsToNodeIdsRequest.class, serviceSet::onTranslateBrowsePaths);
        this.addRequestHandler(RegisterNodesRequest.class, serviceSet::onRegisterNodes);
        this.addRequestHandler(UnregisterNodesRequest.class, serviceSet::onUnregisterNodes);
    }
}

