/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCertificateManager
implements CertificateManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ByteString, KeyPair> privateKeys = Maps.newConcurrentMap();
    private final Map<ByteString, X509Certificate> certificates = Maps.newConcurrentMap();

    public DefaultCertificateManager() {
        this((KeyPair)null, null);
    }

    public DefaultCertificateManager(KeyPair privateKey, X509Certificate certificate) {
        this(Lists.newArrayList((Object[])new KeyPair[]{privateKey}), Lists.newArrayList((Object[])new X509Certificate[]{certificate}));
    }

    public DefaultCertificateManager(List<KeyPair> privateKeys, List<X509Certificate> certificates) {
        Preconditions.checkState((privateKeys.size() == certificates.size() ? 1 : 0) != 0, (Object)"privateKeys.size() and certificates.size() must be equal");
        for (int i = 0; i < privateKeys.size(); ++i) {
            KeyPair privateKey = privateKeys.get(0);
            X509Certificate certificate = certificates.get(0);
            if (privateKey == null || certificate == null) continue;
            try {
                ByteString thumbprint = ByteString.of(DigestUtil.sha1(certificate.getEncoded()));
                this.privateKeys.put(thumbprint, privateKey);
                this.certificates.put(thumbprint, certificate);
                continue;
            }
            catch (CertificateEncodingException e) {
                this.logger.error("Error getting certificate thumbprint.", (Throwable)e);
            }
        }
    }

    @Override
    public Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return Optional.ofNullable(this.privateKeys.get(thumbprint));
    }

    @Override
    public Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        return Optional.ofNullable(this.certificates.get(thumbprint));
    }

    @Override
    public Set<KeyPair> getKeyPairs() {
        return Sets.newHashSet(this.privateKeys.values());
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        return Sets.newHashSet(this.certificates.values());
    }
}

