/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public enum BuiltinDataType {
    Boolean(1, Boolean.class),
    SByte(2, Byte.class),
    Byte(3, UByte.class),
    Int16(4, Short.class),
    UInt16(5, UShort.class),
    Int32(6, Integer.class),
    UInt32(7, UInteger.class),
    Int64(8, Long.class),
    UInt64(9, ULong.class),
    Float(10, Float.class),
    Double(11, Double.class),
    String(12, String.class),
    DateTime(13, DateTime.class),
    Guid(14, UUID.class),
    ByteString(15, ByteString.class),
    XmlElement(16, XmlElement.class),
    NodeId(17, NodeId.class),
    ExpandedNodeId(18, ExpandedNodeId.class),
    StatusCode(19, StatusCode.class),
    QualifiedName(20, QualifiedName.class),
    LocalizedText(21, LocalizedText.class),
    ExtensionObject(22, ExtensionObject.class),
    DataValue(23, DataValue.class),
    Variant(24, Variant.class),
    DiagnosticInfo(25, DiagnosticInfo.class);

    private final int typeId;
    private final Class<?> backingClass;
    private static final BiMap<Integer, Class<?>> BackingClassesById;
    private static final BiMap<NodeId, Class<?>> BackingClassesByNodeId;

    private BuiltinDataType(int typeId, Class<?> backingClass) {
        this.typeId = typeId;
        this.backingClass = backingClass;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public Class<?> getBackingClass() {
        return this.backingClass;
    }

    public static int getBuiltinTypeId(Class<?> backingClass) {
        if (backingClass.isPrimitive()) {
            if (backingClass == java.lang.Boolean.TYPE) {
                backingClass = Boolean.class;
            } else if (backingClass == java.lang.Byte.TYPE) {
                backingClass = Byte.class;
            } else if (backingClass == Short.TYPE) {
                backingClass = Short.class;
            } else if (backingClass == Integer.TYPE) {
                backingClass = Integer.class;
            } else if (backingClass == Long.TYPE) {
                backingClass = Long.class;
            } else if (backingClass == java.lang.Float.TYPE) {
                backingClass = Float.class;
            } else if (backingClass == java.lang.Double.TYPE) {
                backingClass = Double.class;
            }
        }
        return (Integer)BackingClassesById.inverse().get(backingClass);
    }

    public static Class<?> getBackingClass(int typeId) {
        return (Class)BackingClassesById.get((Object)typeId);
    }

    public static Class<?> getBackingClass(NodeId typeId) {
        return (Class)BackingClassesByNodeId.get((Object)typeId);
    }

    public static Class<?> getBackingClass(ExpandedNodeId typeId) {
        if (typeId.getNamespaceIndex().intValue() == 0 && typeId.getType() == IdType.Numeric) {
            Number id = (Number)typeId.getIdentifier();
            return (Class)BackingClassesById.get((Object)id.intValue());
        }
        return null;
    }

    public static boolean isBuiltin(int typeId) {
        return BackingClassesById.containsKey((Object)typeId);
    }

    public static boolean isBuiltin(NodeId typeId) {
        return BackingClassesByNodeId.containsKey((Object)typeId);
    }

    public static boolean isBuiltin(ExpandedNodeId typeId) {
        return typeId.local().map(arg_0 -> BackingClassesByNodeId.containsKey(arg_0)).orElse(false);
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder builder2 = ImmutableBiMap.builder();
        for (BuiltinDataType dataType : BuiltinDataType.values()) {
            builder.put((Object)dataType.getTypeId(), dataType.getBackingClass());
            builder2.put((Object)new NodeId(0, dataType.getTypeId()), dataType.getBackingClass());
        }
        BackingClassesById = builder.build();
        BackingClassesByNodeId = builder2.build();
    }
}

