/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientChannelManager {
    private static final int MAX_RECONNECT_DELAY_SECONDS = 16;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<Idle>(new Idle());
    private final UaTcpStackClient client;

    ClientChannelManager(UaTcpStackClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientSecureChannel> getChannel() {
        State currentState = this.state.get();
        this.logger.trace("getChannel(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof Idle) {
            Connecting nextState = new Connecting();
            if (this.state.compareAndSet(currentState, nextState)) {
                CompletableFuture<ClientSecureChannel> connected = nextState.connected;
                this.connect(true, connected);
                return connected.whenCompleteAsync((sc, ex) -> {
                    if (sc != null) {
                        if (this.state.compareAndSet(nextState, new Connected(connected))) {
                            sc.getChannel().pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                        }
                    } else {
                        this.state.compareAndSet(nextState, new Idle());
                    }
                });
            }
            return this.getChannel();
        }
        if (currentState instanceof Connecting) {
            return ((Connecting)currentState).connected;
        }
        if (currentState instanceof Connected) {
            return ((Connected)currentState).connected;
        }
        if (currentState instanceof Reconnecting) {
            return ((Reconnecting)currentState).reconnected;
        }
        if (currentState instanceof Disconnecting) {
            CompletableFuture<ClientSecureChannel> future = new CompletableFuture<ClientSecureChannel>();
            CompletableFuture<Unit> disconnectFuture = ((Disconnecting)currentState).disconnectFuture;
            disconnectFuture.whenCompleteAsync((u, ex) -> this.getChannel().whenCompleteAsync((sc, ex2) -> {
                if (sc != null) {
                    future.complete((ClientSecureChannel)sc);
                } else {
                    future.completeExceptionally((Throwable)ex2);
                }
            }), (Executor)this.client.getExecutorService());
            return future;
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    public CompletableFuture<Unit> disconnect() {
        State currentState = this.state.get();
        this.logger.trace("disconnect(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof Idle) {
            CompletableFuture<Unit> f = new CompletableFuture<Unit>();
            f.complete(Unit.VALUE);
            return f;
        }
        if (currentState instanceof Connected) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                ((Connected)currentState).connected.whenCompleteAsync((sc, ex) -> {
                    if (sc != null) {
                        this.disconnect((ClientSecureChannel)sc, disconnecting.disconnectFuture);
                    } else {
                        disconnecting.disconnectFuture.complete(null);
                    }
                    disconnecting.disconnectFuture.whenComplete((u, ex2) -> {
                        if (this.state.compareAndSet(disconnecting, new Idle())) {
                            this.logger.debug("disconnect complete, state set to Idle");
                        }
                    });
                });
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Connecting) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                ((Connecting)currentState).connected.whenCompleteAsync((sc, ex) -> {
                    if (sc != null) {
                        this.disconnect((ClientSecureChannel)sc, disconnecting.disconnectFuture);
                    } else {
                        disconnecting.disconnectFuture.complete(Unit.VALUE);
                    }
                    disconnecting.disconnectFuture.whenComplete((u, ex2) -> {
                        if (this.state.compareAndSet(disconnecting, new Idle())) {
                            this.logger.debug("disconnect complete, state set to Idle");
                        }
                    });
                });
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Reconnecting) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                ((Reconnecting)currentState).reconnected.whenCompleteAsync((sc, ex) -> {
                    if (sc != null) {
                        this.disconnect((ClientSecureChannel)sc, disconnecting.disconnectFuture);
                    } else {
                        disconnecting.disconnectFuture.complete(Unit.VALUE);
                    }
                    disconnecting.disconnectFuture.whenComplete((u, ex2) -> {
                        if (this.state.compareAndSet(disconnecting, new Idle())) {
                            this.logger.debug("disconnect complete, state set to Idle");
                        }
                    });
                });
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Disconnecting) {
            return ((Disconnecting)currentState).disconnectFuture;
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    private void connect(boolean initialAttempt, CompletableFuture<ClientSecureChannel> future) {
        UaTcpStackClient.bootstrap(this.client, Optional.empty()).whenCompleteAsync((sc, ex) -> {
            if (sc != null) {
                this.logger.debug("Channel bootstrap succeeded: localAddress={}, remoteAddress={}", (Object)sc.getChannel().localAddress(), (Object)sc.getChannel().remoteAddress());
                future.complete((ClientSecureChannel)sc);
            } else {
                boolean secureChannelError;
                this.logger.debug("Channel bootstrap failed: {}", (Object)ex.getMessage(), ex);
                StatusCode statusCode = UaException.extract(ex).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                boolean bl = secureChannelError = statusCode.getValue() == 0x80220000L || statusCode.getValue() == 2148728832L || statusCode.getValue() == 2155806720L;
                if (initialAttempt && secureChannelError) {
                    this.logger.debug("Previous channel unusable, retrying...");
                    this.connect(false, future);
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
            }
        });
    }

    private void reconnect(Reconnecting reconnectState, long delaySeconds) {
        this.logger.debug("Scheduling reconnect for +{} seconds...", (Object)delaySeconds);
        Stack.sharedScheduledExecutor().schedule(() -> {
            this.logger.debug("{} seconds elapsed; reconnecting...", (Object)delaySeconds);
            CompletableFuture<ClientSecureChannel> reconnected = reconnectState.reconnected;
            this.connect(true, reconnected);
            reconnected.whenCompleteAsync((sc, ex) -> {
                if (sc != null) {
                    this.logger.debug("Reconnect succeeded, channelId={}", (Object)sc.getChannelId());
                    if (this.state.compareAndSet(reconnectState, new Connected(reconnected))) {
                        sc.getChannel().pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                    }
                } else {
                    this.logger.debug("Reconnect failed: {}", (Object)ex.getMessage(), ex);
                    Reconnecting nextState = new Reconnecting();
                    if (this.state.compareAndSet(reconnectState, nextState)) {
                        this.reconnect(nextState, ClientChannelManager.nextDelay(delaySeconds));
                    }
                }
            });
        }, delaySeconds, TimeUnit.SECONDS);
    }

    private void disconnect(ClientSecureChannel secureChannel, final CompletableFuture<Unit> disconnected) {
        RequestHeader requestHeader = new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint(0), Unsigned.uint(0), null, Unsigned.uint(0), null);
        secureChannel.getChannel().pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                ClientChannelManager.this.logger.debug("channelInactive(), disconnect complete");
                disconnected.complete(Unit.VALUE);
            }
        }});
        this.logger.debug("Sending CloseSecureChannelRequest...");
        CloseSecureChannelRequest request = new CloseSecureChannelRequest(requestHeader);
        secureChannel.getChannel().pipeline().fireUserEventTriggered((Object)request);
    }

    private static long nextDelay(long delaySeconds) {
        if (delaySeconds == 0L) {
            return 1L;
        }
        return Math.min(delaySeconds << 1, 16L);
    }

    private static class Disconnecting
    implements State {
        final CompletableFuture<Unit> disconnectFuture = new CompletableFuture();

        private Disconnecting() {
        }
    }

    private static class Reconnecting
    implements State {
        final CompletableFuture<ClientSecureChannel> reconnected = new CompletableFuture();

        private Reconnecting() {
        }
    }

    private static class Connected
    implements State {
        final CompletableFuture<ClientSecureChannel> connected;

        Connected(CompletableFuture<ClientSecureChannel> connected) {
            this.connected = connected;
        }
    }

    private static class Connecting
    implements State {
        final CompletableFuture<ClientSecureChannel> connected = new CompletableFuture();

        private Connecting() {
        }
    }

    private static class Idle
    implements State {
        private Idle() {
        }
    }

    private static interface State {
    }

    private class InactivityHandler
    extends ChannelInboundHandlerAdapter {
        private InactivityHandler() {
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            State currentState = (State)ClientChannelManager.this.state.get();
            if (currentState instanceof Disconnecting) {
                Idle nextState = new Idle();
                ClientChannelManager.this.state.compareAndSet(currentState, nextState);
                ((Disconnecting)currentState).disconnectFuture.complete(Unit.VALUE);
            } else {
                Reconnecting nextState = new Reconnecting();
                if (ClientChannelManager.this.state.compareAndSet(currentState, nextState)) {
                    if (currentState instanceof Connected && !ClientChannelManager.this.client.getConfig().isSecureChannelReauthenticationEnabled()) {
                        ((Connected)currentState).connected.thenAccept(sc -> sc.setChannelId(0L));
                    }
                    ClientChannelManager.this.reconnect(nextState, 0L);
                }
            }
            super.channelInactive(ctx);
        }
    }
}

