/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AttributeManager;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredEventItem;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PendingItemCreation;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PendingItemModification;
import org.eclipse.milo.opcua.sdk.server.subscriptions.PublishQueue;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.jooq.lambda.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final QualifiedName DEFAULT_BINARY_ENCODING = new QualifiedName(0, "DefaultBinary");
    private static final QualifiedName DEFAULT_XML_ENCODING = new QualifiedName(0, "DefaultXML");
    private static final AtomicLong SUBSCRIPTION_IDS = new AtomicLong(0L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<UInteger, StatusCode[]> acknowledgeResults = Maps.newConcurrentMap();
    private final PublishQueue publishQueue = new PublishQueue();
    private final Map<UInteger, Subscription> subscriptions = Maps.newConcurrentMap();
    private final List<Subscription> transferred = Lists.newCopyOnWriteArrayList();
    private final Session session;
    private final OpcUaServer server;

    private static UInteger nextSubscriptionId() {
        return Unsigned.uint(SUBSCRIPTION_IDS.incrementAndGet());
    }

    public SubscriptionManager(Session session, OpcUaServer server) {
        this.session = session;
        this.server = server;
    }

    public Session getSession() {
        return this.session;
    }

    public PublishQueue getPublishQueue() {
        return this.publishQueue;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public void createSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) {
        CreateSubscriptionRequest request = service.getRequest();
        UInteger subscriptionId = SubscriptionManager.nextSubscriptionId();
        Subscription subscription = new Subscription(this, subscriptionId, request.getRequestedPublishingInterval(), request.getRequestedMaxKeepAliveCount().longValue(), request.getRequestedLifetimeCount().longValue(), request.getMaxNotificationsPerPublish().longValue(), request.getPublishingEnabled(), request.getPriority().intValue());
        this.subscriptions.put(subscriptionId, subscription);
        this.server.getSubscriptions().put(subscriptionId, subscription);
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closed) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
            }
        });
        subscription.startPublishingTimer();
        ResponseHeader header = service.createResponseHeader();
        CreateSubscriptionResponse response = new CreateSubscriptionResponse(header, subscriptionId, subscription.getPublishingInterval(), Unsigned.uint(subscription.getLifetimeCount()), Unsigned.uint(subscription.getMaxKeepAliveCount()));
        service.setResponse(response);
    }

    public void modifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) {
        ModifySubscriptionRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            subscription.modifySubscription(request);
            ResponseHeader header = service.createResponseHeader();
            ModifySubscriptionResponse response = new ModifySubscriptionResponse(header, subscription.getPublishingInterval(), Unsigned.uint(subscription.getLifetimeCount()), Unsigned.uint(subscription.getMaxKeepAliveCount()));
            service.setResponse(response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void deleteSubscription(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) {
        DeleteSubscriptionsRequest request = service.getRequest();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        if (subscriptionIds.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        StatusCode[] results = new StatusCode[subscriptionIds.size()];
        for (int i = 0; i < subscriptionIds.size(); ++i) {
            Subscription subscription = this.subscriptions.remove(subscriptionIds.get(i));
            if (subscription != null) {
                List<BaseMonitoredItem<?>> deletedItems = subscription.deleteSubscription();
                Map<UShort, List<BaseMonitoredItem>> byNamespace = deletedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsDeleted(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsDeleted(eventItems);
                    }
                });
                results[i] = StatusCode.GOOD;
                continue;
            }
            results[i] = new StatusCode(0x80280000L);
        }
        ResponseHeader header = service.createResponseHeader();
        DeleteSubscriptionsResponse response = new DeleteSubscriptionsResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse(response);
        while (this.subscriptions.isEmpty() && this.publishQueue.isNotEmpty()) {
            ServiceRequest<PublishRequest, PublishResponse> publishService = this.publishQueue.poll();
            if (publishService == null) continue;
            publishService.setServiceFault(2155413504L);
        }
    }

    public void setPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) {
        SetPublishingModeRequest request = service.getRequest();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        StatusCode[] results = new StatusCode[subscriptionIds.size()];
        for (int i = 0; i < subscriptionIds.size(); ++i) {
            Subscription subscription = this.subscriptions.get(subscriptionIds.get(i));
            if (subscription == null) {
                results[i] = new StatusCode(0x80280000L);
                continue;
            }
            subscription.setPublishingMode(request);
            results[i] = StatusCode.GOOD;
        }
        ResponseHeader header = service.createResponseHeader();
        SetPublishingModeResponse response = new SetPublishingModeResponse(header, results, new DiagnosticInfo[0]);
        service.setResponse(response);
    }

    public void createMonitoredItems(ServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> service) {
        CreateMonitoredItemsRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            TimestampsToReturn timestamps = service.getRequest().getTimestampsToReturn();
            List<MonitoredItemCreateRequest> itemsToCreate = ConversionUtil.l(service.getRequest().getItemsToCreate());
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (timestamps == null) {
                throw new UaException(2150301696L);
            }
            if (itemsToCreate.isEmpty()) {
                throw new UaException(0x800F0000L);
            }
            List createdItems = Collections.synchronizedList(Lists.newArrayListWithCapacity((int)itemsToCreate.size()));
            List pending = itemsToCreate.stream().map(PendingItemCreation::new).collect(Collectors.toList());
            for (PendingItemCreation p : pending) {
                MonitoredItemCreateResult result;
                MonitoredItemCreateRequest r = p.getRequest();
                NodeId nodeId = r.getItemToMonitor().getNodeId();
                UInteger attributeId = r.getItemToMonitor().getAttributeId();
                QualifiedName dataEncoding = r.getItemToMonitor().getDataEncoding();
                if (!AttributeId.isValid(attributeId)) {
                    result = new MonitoredItemCreateResult(new StatusCode(2150957056L), Unsigned.uint(0), 0.0, Unsigned.uint(0), null);
                    p.getResultFuture().complete(result);
                    continue;
                }
                if (dataEncoding.isNotNull()) {
                    if (!AttributeId.Value.isEqual(attributeId)) {
                        result = new MonitoredItemCreateResult(new StatusCode(0x80380000L), Unsigned.uint(0), 0.0, Unsigned.uint(0), null);
                        p.getResultFuture().complete(result);
                        continue;
                    }
                    if (!dataEncoding.equals(DEFAULT_BINARY_ENCODING) && !dataEncoding.equals(DEFAULT_XML_ENCODING)) {
                        result = new MonitoredItemCreateResult(new StatusCode(2151219200L), Unsigned.uint(0), 0.0, Unsigned.uint(0), null);
                        p.getResultFuture().complete(result);
                        continue;
                    }
                }
                Namespace namespace = this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex());
                if (attributeId.equals(AttributeId.EventNotifier.uid())) {
                    this.readEventAttributes(namespace, nodeId).thenAccept(as -> {
                        Optional eventNotifier = (Optional)as.v3();
                        try {
                            if (!eventNotifier.isPresent()) {
                                throw new UaException(2150957056L);
                            }
                            MonitoredEventItem item = new MonitoredEventItem(Unsigned.uint(subscription.nextItemId()), subscriptionId, r.getItemToMonitor(), r.getMonitoringMode(), timestamps, r.getRequestedParameters().getClientHandle(), 0.0, r.getRequestedParameters().getQueueSize(), r.getRequestedParameters().getDiscardOldest(), r.getRequestedParameters().getFilter());
                            createdItems.add(item);
                            MonitoredItemCreateResult result = new MonitoredItemCreateResult(StatusCode.GOOD, item.getId(), item.getSamplingInterval(), Unsigned.uint(item.getQueueSize()), item.getFilterResult());
                            p.getResultFuture().complete(result);
                        }
                        catch (UaException e) {
                            MonitoredItemCreateResult result = new MonitoredItemCreateResult(e.getStatusCode(), Unsigned.uint(0), 0.0, Unsigned.uint(0), null);
                            p.getResultFuture().complete(result);
                        }
                    });
                    continue;
                }
                this.readDataAttributes(this.session, namespace, nodeId).thenAccept(vs -> {
                    try {
                        for (DataValue value : vs) {
                            StatusCode statusCode = value.getStatusCode();
                            if (statusCode.getValue() != 0x80330000L && statusCode.getValue() != 2150891520L) continue;
                            throw new UaException(statusCode);
                        }
                        UByte accessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(0)).getValue().getValue()).orElse(Unsigned.ubyte(1));
                        UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(1)).getValue().getValue()).orElse(Unsigned.ubyte(1));
                        Double minimumSamplingInterval = Optional.ofNullable((Double)((DataValue)vs.get(2)).getValue().getValue()).orElse(0.0);
                        EnumSet<AccessLevel> accessLevels = AccessLevel.fromMask(accessLevel);
                        EnumSet<AccessLevel> userAccessLevels = AccessLevel.fromMask(userAccessLevel);
                        double samplingInterval = r.getRequestedParameters().getSamplingInterval();
                        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
                        if (samplingInterval < 0.0) {
                            samplingInterval = subscription.getPublishingInterval();
                        }
                        if (samplingInterval < minimumSamplingInterval) {
                            samplingInterval = minimumSamplingInterval;
                        }
                        if (samplingInterval < minSupportedSampleRate) {
                            samplingInterval = minSupportedSampleRate;
                        }
                        if (samplingInterval > maxSupportedSampleRate) {
                            samplingInterval = maxSupportedSampleRate;
                        }
                        if (!accessLevels.contains((Object)AccessLevel.CurrentRead)) {
                            throw new UaException(2151284736L);
                        }
                        if (!userAccessLevels.contains((Object)AccessLevel.CurrentRead)) {
                            throw new UaException(2149515264L);
                        }
                        String indexRange = r.getItemToMonitor().getIndexRange();
                        if (indexRange != null) {
                            NumericRange.parse(indexRange);
                        }
                        MonitoredDataItem item = new MonitoredDataItem(Unsigned.uint(subscription.nextItemId()), subscriptionId, r.getItemToMonitor(), r.getMonitoringMode(), timestamps, r.getRequestedParameters().getClientHandle(), samplingInterval, r.getRequestedParameters().getFilter(), r.getRequestedParameters().getQueueSize(), r.getRequestedParameters().getDiscardOldest());
                        createdItems.add(item);
                        MonitoredItemCreateResult result = new MonitoredItemCreateResult(StatusCode.GOOD, item.getId(), item.getSamplingInterval(), Unsigned.uint(item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                    catch (Throwable t) {
                        StatusCode statusCode = UaException.extract(t).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                        MonitoredItemCreateResult result = new MonitoredItemCreateResult(statusCode, Unsigned.uint(0), 0.0, Unsigned.uint(0), null);
                        p.getResultFuture().complete(result);
                    }
                });
            }
            List futures = pending.stream().map(PendingItemCreation::getResultFuture).collect(Collectors.toList());
            FutureUtils.sequence(futures).thenAccept(results -> {
                subscription.addMonitoredItems(createdItems);
                Map<UShort, List<BaseMonitoredItem>> byNamespace = createdItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsCreated(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsCreated(eventItems);
                    }
                });
                ResponseHeader header = service.createResponseHeader();
                CreateMonitoredItemsResponse response = new CreateMonitoredItemsResponse(header, ConversionUtil.a(results, MonitoredItemCreateResult.class), new DiagnosticInfo[0]);
                service.setResponse(response);
            });
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void modifyMonitoredItems(ServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> service) {
        ModifyMonitoredItemsRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            TimestampsToReturn timestamps = service.getRequest().getTimestampsToReturn();
            List<MonitoredItemModifyRequest> itemsToModify = ConversionUtil.l(service.getRequest().getItemsToModify());
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (timestamps == null) {
                throw new UaException(2150301696L);
            }
            if (itemsToModify.isEmpty()) {
                throw new UaException(0x800F0000L);
            }
            List pending = itemsToModify.stream().map(PendingItemModification::new).collect(Collectors.toList());
            List modifiedItems = Collections.synchronizedList(Lists.newArrayListWithCapacity((int)itemsToModify.size()));
            for (PendingItemModification p : pending) {
                MonitoredItemModifyRequest r = p.getRequest();
                UInteger itemId = r.getMonitoredItemId();
                MonitoringParameters parameters = r.getRequestedParameters();
                BaseMonitoredItem<?> item = subscription.getMonitoredItems().get(itemId);
                if (item == null) {
                    MonitoredItemModifyResult result = new MonitoredItemModifyResult(new StatusCode(2151809024L), 0.0, Unsigned.uint(0), null);
                    p.getResultFuture().complete(result);
                    continue;
                }
                NodeId nodeId = item.getReadValueId().getNodeId();
                Namespace namespace = this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex());
                this.readDataAttributes(this.session, namespace, nodeId).thenAccept(vs -> {
                    try {
                        for (DataValue value : vs) {
                            StatusCode statusCode = value.getStatusCode();
                            if (statusCode.getValue() != 0x80330000L && statusCode.getValue() != 2150891520L) continue;
                            throw new UaException(statusCode);
                        }
                        UByte accessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(0)).getValue().getValue()).orElse(Unsigned.ubyte(1));
                        UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)vs.get(1)).getValue().getValue()).orElse(Unsigned.ubyte(1));
                        Double minimumSamplingInterval = Optional.ofNullable((Double)((DataValue)vs.get(2)).getValue().getValue()).orElse(0.0);
                        EnumSet<AccessLevel> accessLevels = AccessLevel.fromMask(accessLevel);
                        EnumSet<AccessLevel> userAccessLevels = AccessLevel.fromMask(userAccessLevel);
                        double samplingInterval = parameters.getSamplingInterval();
                        double minSupportedSampleRate = this.server.getConfig().getLimits().getMinSupportedSampleRate();
                        double maxSupportedSampleRate = this.server.getConfig().getLimits().getMaxSupportedSampleRate();
                        if (samplingInterval < 0.0) {
                            samplingInterval = subscription.getPublishingInterval();
                        }
                        if (samplingInterval < minimumSamplingInterval) {
                            samplingInterval = minimumSamplingInterval;
                        }
                        if (samplingInterval < minSupportedSampleRate) {
                            samplingInterval = minSupportedSampleRate;
                        }
                        if (samplingInterval > maxSupportedSampleRate) {
                            samplingInterval = maxSupportedSampleRate;
                        }
                        item.modify(timestamps, parameters.getClientHandle(), samplingInterval, parameters.getFilter(), parameters.getQueueSize(), parameters.getDiscardOldest());
                        modifiedItems.add(item);
                        MonitoredItemModifyResult result = new MonitoredItemModifyResult(StatusCode.GOOD, item.getSamplingInterval(), Unsigned.uint(item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                    catch (Throwable t) {
                        StatusCode statusCode = UaException.extract(t).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                        MonitoredItemModifyResult result = new MonitoredItemModifyResult(statusCode, item.getSamplingInterval(), Unsigned.uint(item.getQueueSize()), item.getFilterResult());
                        p.getResultFuture().complete(result);
                    }
                });
            }
            subscription.resetLifetimeCounter();
            List futures = pending.stream().map(PendingItemModification::getResultFuture).collect(Collectors.toList());
            FutureUtils.sequence(futures).thenAccept(results -> {
                Map<UShort, List<BaseMonitoredItem>> byNamespace = modifiedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
                byNamespace.entrySet().forEach(entry -> {
                    UShort namespaceIndex = (UShort)entry.getKey();
                    List items = (List)entry.getValue();
                    ArrayList dataItems = Lists.newArrayList();
                    ArrayList eventItems = Lists.newArrayList();
                    for (BaseMonitoredItem item : items) {
                        if (item instanceof MonitoredDataItem) {
                            dataItems.add((DataItem)((Object)item));
                            continue;
                        }
                        if (!(item instanceof MonitoredEventItem)) continue;
                        eventItems.add((EventItem)((Object)item));
                    }
                    if (!dataItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsModified(dataItems);
                    }
                    if (!eventItems.isEmpty()) {
                        this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsModified(eventItems);
                    }
                });
                ResponseHeader header = service.createResponseHeader();
                ModifyMonitoredItemsResponse response = new ModifyMonitoredItemsResponse(header, ConversionUtil.a(results, MonitoredItemModifyResult.class), new DiagnosticInfo[0]);
                service.setResponse(response);
            });
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    private CompletableFuture<List<DataValue>> readDataAttributes(Session session, Namespace namespace, NodeId itemId) {
        Function<AttributeId, ReadValueId> f = id -> new ReadValueId(itemId, id.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
        AttributeManager.ReadContext readContext = new AttributeManager.ReadContext(this.server, session, future, new DiagnosticsContext<ReadValueId>());
        ArrayList attributes = Lists.newArrayList((Object[])new ReadValueId[]{f.apply(AttributeId.AccessLevel), f.apply(AttributeId.UserAccessLevel), f.apply(AttributeId.MinimumSamplingInterval)});
        namespace.read(readContext, 0.0, TimestampsToReturn.Neither, attributes);
        return future;
    }

    private CompletableFuture<EventAttributes> readEventAttributes(Namespace namespace, NodeId nodeId) {
        Function<AttributeId, ReadValueId> f = id -> new ReadValueId(nodeId, id.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
        AttributeManager.ReadContext readContext = new AttributeManager.ReadContext(this.server, null, future, new DiagnosticsContext<ReadValueId>());
        ArrayList readValueIds = Lists.newArrayList((Object[])new ReadValueId[]{f.apply(AttributeId.AccessLevel), f.apply(AttributeId.UserAccessLevel), f.apply(AttributeId.EventNotifier)});
        namespace.read(readContext, 0.0, TimestampsToReturn.Neither, readValueIds);
        return future.thenApply(values -> {
            UByte accessLevel = Optional.ofNullable((UByte)((DataValue)values.get(0)).getValue().getValue()).orElse(Unsigned.ubyte(1));
            UByte userAccessLevel = Optional.ofNullable((UByte)((DataValue)values.get(1)).getValue().getValue()).orElse(Unsigned.ubyte(1));
            Optional<UByte> eventNotifier = Optional.ofNullable((UByte)((DataValue)values.get(2)).getValue().getValue());
            return new EventAttributes(AccessLevel.fromMask(accessLevel), AccessLevel.fromMask(userAccessLevel), eventNotifier);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMonitoredItems(ServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> service) {
        DeleteMonitoredItemsRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            List<UInteger> itemsToDelete = ConversionUtil.l(service.getRequest().getMonitoredItemIds());
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (itemsToDelete.isEmpty()) {
                throw new UaException(0x800F0000L);
            }
            StatusCode[] deleteResults = new StatusCode[itemsToDelete.size()];
            ArrayList deletedItems = Lists.newArrayListWithCapacity((int)itemsToDelete.size());
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                for (int i = 0; i < itemsToDelete.size(); ++i) {
                    UInteger itemId = itemsToDelete.get(i);
                    BaseMonitoredItem<?> item2 = subscription.getMonitoredItems().get(itemId);
                    if (item2 == null) {
                        deleteResults[i] = new StatusCode(2151809024L);
                        continue;
                    }
                    deletedItems.add(item2);
                    deleteResults[i] = StatusCode.GOOD;
                }
                subscription.removeMonitoredItems(deletedItems);
            }
            Map<UShort, List<BaseMonitoredItem>> byNamespace = deletedItems.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
            byNamespace.entrySet().forEach(entry -> {
                UShort namespaceIndex = (UShort)entry.getKey();
                List items = (List)entry.getValue();
                ArrayList dataItems = Lists.newArrayList();
                ArrayList eventItems = Lists.newArrayList();
                for (BaseMonitoredItem item : items) {
                    if (item instanceof MonitoredDataItem) {
                        dataItems.add((DataItem)((Object)item));
                        continue;
                    }
                    if (!(item instanceof MonitoredEventItem)) continue;
                    eventItems.add((EventItem)((Object)item));
                }
                if (!dataItems.isEmpty()) {
                    this.server.getNamespaceManager().getNamespace(namespaceIndex).onDataItemsDeleted(dataItems);
                }
                if (!eventItems.isEmpty()) {
                    this.server.getNamespaceManager().getNamespace(namespaceIndex).onEventItemsDeleted(eventItems);
                }
            });
            ResponseHeader header = service.createResponseHeader();
            DeleteMonitoredItemsResponse response = new DeleteMonitoredItemsResponse(header, deleteResults, new DiagnosticInfo[0]);
            service.setResponse(response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void setMonitoringMode(ServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> service) {
        SetMonitoringModeRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        try {
            Subscription subscription = this.subscriptions.get(subscriptionId);
            List<UInteger> itemsToModify = ConversionUtil.l(request.getMonitoredItemIds());
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (itemsToModify.isEmpty()) {
                throw new UaException(0x800F0000L);
            }
            MonitoringMode monitoringMode = request.getMonitoringMode();
            StatusCode[] results = new StatusCode[itemsToModify.size()];
            ArrayList modified = Lists.newArrayListWithCapacity((int)itemsToModify.size());
            for (int i = 0; i < itemsToModify.size(); ++i) {
                UInteger itemId = itemsToModify.get(i);
                BaseMonitoredItem<?> item2 = subscription.getMonitoredItems().get(itemId);
                if (item2 != null) {
                    item2.setMonitoringMode(monitoringMode);
                    modified.add(item2);
                    results[i] = StatusCode.GOOD;
                    continue;
                }
                results[i] = new StatusCode(2151809024L);
            }
            Map<UShort, List<MonitoredItem>> byNamespace = modified.stream().collect(Collectors.groupingBy(item -> item.getReadValueId().getNodeId().getNamespaceIndex()));
            byNamespace.keySet().forEach(namespaceIndex -> {
                List items = (List)byNamespace.get(namespaceIndex);
                this.server.getNamespaceManager().getNamespace((UShort)namespaceIndex).onMonitoringModeChanged(items);
            });
            ResponseHeader header = service.createResponseHeader();
            SetMonitoringModeResponse response = new SetMonitoringModeResponse(header, results, new DiagnosticInfo[0]);
            service.setResponse(response);
        }
        catch (UaException e) {
            service.setServiceFault(e);
        }
    }

    public void publish(ServiceRequest<PublishRequest, PublishResponse> service) {
        PublishRequest request = service.getRequest();
        if (!this.transferred.isEmpty()) {
            Subscription subscription = this.transferred.remove(0);
            subscription.returnStatusChangeNotification(service);
            return;
        }
        if (this.subscriptions.isEmpty()) {
            service.setServiceFault(2155413504L);
            return;
        }
        SubscriptionAcknowledgement[] acknowledgements = request.getSubscriptionAcknowledgements();
        if (acknowledgements != null) {
            StatusCode[] results = new StatusCode[acknowledgements.length];
            for (int i = 0; i < acknowledgements.length; ++i) {
                SubscriptionAcknowledgement acknowledgement = acknowledgements[i];
                UInteger sequenceNumber = acknowledgement.getSequenceNumber();
                UInteger subscriptionId = acknowledgement.getSubscriptionId();
                this.logger.debug("Acknowledging sequenceNumber={} on subscriptionId={}", (Object)sequenceNumber, (Object)subscriptionId);
                Subscription subscription = this.subscriptions.get(subscriptionId);
                results[i] = subscription == null ? new StatusCode(0x80280000L) : subscription.acknowledge(sequenceNumber);
            }
            this.acknowledgeResults.put(request.getRequestHeader().getRequestHandle(), results);
        }
        this.publishQueue.addRequest(service);
    }

    public void republish(ServiceRequest<RepublishRequest, RepublishResponse> service) {
        RepublishRequest request = service.getRequest();
        if (this.subscriptions.isEmpty()) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger sequenceNumber = request.getRetransmitSequenceNumber();
        NotificationMessage notificationMessage = subscription.republish(sequenceNumber);
        if (notificationMessage == null) {
            service.setServiceFault(2155544576L);
            return;
        }
        ResponseHeader header = service.createResponseHeader();
        RepublishResponse response = new RepublishResponse(header, notificationMessage);
        service.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggering(ServiceRequest<SetTriggeringRequest, SetTriggeringResponse> service) {
        SetTriggeringRequest request = service.getRequest();
        UInteger subscriptionId = request.getSubscriptionId();
        Subscription subscription = this.subscriptions.get(subscriptionId);
        if (subscription == null) {
            service.setServiceFault(0x80280000L);
            return;
        }
        UInteger triggerId = request.getTriggeringItemId();
        List<UInteger> linksToAdd = ConversionUtil.l(request.getLinksToAdd());
        List<UInteger> linksToRemove = ConversionUtil.l(request.getLinksToRemove());
        if (linksToAdd.isEmpty() && linksToRemove.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        Subscription subscription2 = subscription;
        synchronized (subscription2) {
            Map<UInteger, BaseMonitoredItem<?>> itemsById = subscription.getMonitoredItems();
            BaseMonitoredItem<?> triggerItem = itemsById.get(triggerId);
            if (triggerItem == null) {
                service.setServiceFault(2151809024L);
                return;
            }
            List<StatusCode> removeResults = linksToRemove.stream().map(linkedItemId -> {
                BaseMonitoredItem item = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (item != null) {
                    if (triggerItem.getTriggeredItems().remove(linkedItemId) != null) {
                        return StatusCode.GOOD;
                    }
                    return new StatusCode(2151809024L);
                }
                return new StatusCode(2151809024L);
            }).collect(Collectors.toList());
            List<StatusCode> addResults = linksToAdd.stream().map(linkedItemId -> {
                BaseMonitoredItem linkedItem = (BaseMonitoredItem)itemsById.get(linkedItemId);
                if (linkedItem != null) {
                    triggerItem.getTriggeredItems().put((UInteger)linkedItemId, linkedItem);
                    return StatusCode.GOOD;
                }
                return new StatusCode(2151809024L);
            }).collect(Collectors.toList());
            SetTriggeringResponse response = new SetTriggeringResponse(service.createResponseHeader(), addResults.toArray(new StatusCode[addResults.size()]), new DiagnosticInfo[0], removeResults.toArray(new StatusCode[removeResults.size()]), new DiagnosticInfo[0]);
            service.setResponse(response);
        }
    }

    public void sessionClosed(boolean deleteSubscriptions) {
        Iterator<Subscription> iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            Subscription s = iterator.next();
            s.setStateListener(null);
            if (deleteSubscriptions) {
                this.server.getSubscriptions().remove(s.getId());
            }
            iterator.remove();
        }
    }

    public Subscription removeSubscription(UInteger subscriptionId) {
        Subscription subscription = this.subscriptions.remove(subscriptionId);
        if (subscription != null) {
            subscription.setStateListener(null);
        }
        return subscription;
    }

    public void addSubscription(Subscription subscription) {
        this.subscriptions.put(subscription.getId(), subscription);
        subscription.setStateListener((s, ps, cs) -> {
            if (cs == Subscription.State.Closed) {
                this.subscriptions.remove(s.getId());
                this.server.getSubscriptions().remove(s.getId());
            }
        });
    }

    StatusCode[] getAcknowledgeResults(UInteger requestHandle) {
        return this.acknowledgeResults.remove(requestHandle);
    }

    public void sendStatusChangeNotification(Subscription subscription) {
        ServiceRequest<PublishRequest, PublishResponse> service = this.publishQueue.poll();
        if (service != null) {
            subscription.returnStatusChangeNotification(service);
        } else {
            this.transferred.add(subscription);
        }
    }

    private static class EventAttributes
    extends Tuple3<EnumSet<AccessLevel>, EnumSet<AccessLevel>, Optional<UByte>> {
        public EventAttributes(EnumSet<AccessLevel> v1, EnumSet<AccessLevel> v2, Optional<UByte> v3) {
            super(v1, v2, v3);
        }
    }
}

