/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class SubscriptionServices
implements SubscriptionServiceSet {
    private final SubscriptionManager subscriptionManager;

    public SubscriptionServices(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public void onCreateSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) {
        this.subscriptionManager.createSubscription(service);
    }

    @Override
    public void onModifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) {
        this.subscriptionManager.modifySubscription(service);
    }

    @Override
    public void onDeleteSubscriptions(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) {
        this.subscriptionManager.deleteSubscription(service);
    }

    @Override
    public void onSetPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) {
        this.subscriptionManager.setPublishingMode(service);
    }

    @Override
    public void onPublish(ServiceRequest<PublishRequest, PublishResponse> service) {
        this.subscriptionManager.publish(service);
    }

    @Override
    public void onRepublish(ServiceRequest<RepublishRequest, RepublishResponse> service) {
        this.subscriptionManager.republish(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransferSubscriptions(ServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        TransferSubscriptionsRequest request = service.getRequest();
        List<UInteger> subscriptionIds = ConversionUtil.l(request.getSubscriptionIds());
        if (subscriptionIds.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        ArrayList results = Lists.newArrayList();
        for (UInteger subscriptionId : subscriptionIds) {
            UInteger[] availableSequenceNumbers;
            Subscription subscription = server.getSubscriptions().get(subscriptionId);
            if (subscription == null) {
                results.add(new TransferResult(new StatusCode(0x80280000L), new UInteger[0]));
                continue;
            }
            Session otherSession = subscription.getSession();
            if (!this.sessionsHaveSameUser(session, otherSession)) {
                results.add(new TransferResult(new StatusCode(2149515264L), new UInteger[0]));
                continue;
            }
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                otherSession.getSubscriptionManager().sendStatusChangeNotification(subscription);
                otherSession.getSubscriptionManager().removeSubscription(subscriptionId);
                subscription.setSubscriptionManager(session.getSubscriptionManager());
                this.subscriptionManager.addSubscription(subscription);
                availableSequenceNumbers = subscription.getAvailableSequenceNumbers();
                if (request.getSendInitialValues().booleanValue()) {
                    subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::clearLastValue);
                }
            }
            results.add(new TransferResult(StatusCode.GOOD, availableSequenceNumbers));
        }
        service.setResponse(new TransferSubscriptionsResponse(service.createResponseHeader(), ConversionUtil.a(results, TransferResult.class), new DiagnosticInfo[0]));
    }

    private boolean sessionsHaveSameUser(Session s1, Session s2) {
        Object identity1 = s1.getIdentityObject();
        Object identity2 = s2.getIdentityObject();
        return Objects.equals(identity1, identity2);
    }
}

