/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.model.BasicProperty;
import org.eclipse.milo.opcua.sdk.core.model.Property;
import org.eclipse.milo.opcua.sdk.core.model.UaOptional;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;

public class UaMethodNode
extends UaNode
implements MethodNode {
    private volatile Optional<MethodInvocationHandler> handler = Optional.empty();
    private volatile Boolean executable;
    private volatile Boolean userExecutable;
    public static final Property<Argument[]> InputArguments = new BasicProperty<Argument[]>(new QualifiedName(0, "InputArguments"), Identifiers.Argument, 1, Argument[].class);
    public static final Property<Argument[]> OutputArguments = new BasicProperty<Argument[]>(new QualifiedName(0, "OutputArguments"), Identifiers.Argument, 1, Argument[].class);
    public static final Property<String> NodeVersion = new BasicProperty<String>(new QualifiedName(0, "NodeVersion"), Identifiers.String, -1, String.class);

    public UaMethodNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean executable, Boolean userExecutable) {
        super(nodeMap, nodeId, NodeClass.Method, browseName, displayName, description, writeMask, userWriteMask);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    @Override
    public Boolean isExecutable() {
        return this.executable;
    }

    @Override
    public Boolean isUserExecutable() {
        return this.userExecutable;
    }

    @Override
    public synchronized void setExecutable(Boolean executable) {
        this.executable = executable;
        this.fireAttributeChanged(AttributeId.Executable, executable);
    }

    @Override
    public synchronized void setUserExecutable(Boolean userExecutable) {
        this.userExecutable = userExecutable;
        this.fireAttributeChanged(AttributeId.UserExecutable, userExecutable);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getAlwaysGeneratesEventNodes() {
        return this.getReferences().stream().filter(Reference.ALWAYS_GENERATES_EVENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<MethodInvocationHandler> getInvocationHandler() {
        return this.handler;
    }

    public void setInvocationHandler(MethodInvocationHandler handler) {
        this.handler = Optional.of(handler);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="InputArguments")
    public Argument[] getInputArguments() {
        return this.getProperty(InputArguments).orElse(null);
    }

    @UaOptional(value="OutputArguments")
    public Argument[] getOutputArguments() {
        return this.getProperty(OutputArguments).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setInputArguments(Argument[] inputArguments) {
        this.setProperty(InputArguments, inputArguments);
    }

    public void setOutputArguments(Argument[] outputArguments) {
        this.setProperty(OutputArguments, outputArguments);
    }

    public static UaMethodNodeBuilder builder(ServerNodeMap nodeMap) {
        return new UaMethodNodeBuilder(nodeMap);
    }

    public static class UaMethodNodeBuilder
    implements Supplier<UaMethodNode> {
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private boolean executable = true;
        private boolean userExecutable = true;
        private final ServerNodeMap nodeMap;

        public UaMethodNodeBuilder(ServerNodeMap nodeMap) {
            this.nodeMap = nodeMap;
        }

        @Override
        public UaMethodNode get() {
            return this.build();
        }

        public UaMethodNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            return new UaMethodNode(this.nodeMap, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.executable, this.userExecutable);
        }

        public UaMethodNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaMethodNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaMethodNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaMethodNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaMethodNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaMethodNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaMethodNodeBuilder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        public UaMethodNodeBuilder setUserExecutable(boolean userExecutable) {
            this.userExecutable = userExecutable;
            return this;
        }
    }
}

