/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BuildInfoNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.ServerStatusType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;

@UaVariableNode(typeName="0:ServerStatusType")
public class ServerStatusNode
extends BaseDataVariableNode
implements ServerStatusType {
    public ServerStatusNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public ServerStatusNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public synchronized DataValue getValue() {
        ServerStatusDataType value = new ServerStatusDataType(this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason());
        return new DataValue(new Variant(value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        super.setValue(value);
        Object o = value.getValue().getValue();
        if (o instanceof ServerStatusDataType) {
            ServerStatusDataType v = (ServerStatusDataType)o;
            this.setStartTime(v.getStartTime());
            this.setCurrentTime(v.getCurrentTime());
            this.setState(v.getState());
            this.setBuildInfo(v.getBuildInfo());
            this.setSecondsTillShutdown(v.getSecondsTillShutdown());
            this.setShutdownReason(v.getShutdownReason());
        }
    }

    @Override
    public DateTime getStartTime() {
        Optional<VariableNode> component = this.getVariableComponent("StartTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getStartTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("StartTime");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setStartTime(DateTime value) {
        this.getVariableComponent("StartTime").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public DateTime getCurrentTime() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentTime");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentTime(DateTime value) {
        this.getVariableComponent("CurrentTime").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public ServerState getState() {
        Optional<VariableNode> component = this.getVariableComponent("State");
        return component.map(node -> (ServerState)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("State");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setState(ServerState value) {
        this.getVariableComponent("State").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public BuildInfo getBuildInfo() {
        Optional<VariableNode> component = this.getVariableComponent("BuildInfo");
        return component.map(node -> (BuildInfo)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BuildInfoNode getBuildInfoNode() {
        Optional<VariableNode> component = this.getVariableComponent("BuildInfo");
        return component.map(node -> (BuildInfoNode)node).orElse(null);
    }

    @Override
    public void setBuildInfo(BuildInfo value) {
        this.getVariableComponent("BuildInfo").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getSecondsTillShutdown() {
        Optional<VariableNode> component = this.getVariableComponent("SecondsTillShutdown");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSecondsTillShutdownNode() {
        Optional<VariableNode> component = this.getVariableComponent("SecondsTillShutdown");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSecondsTillShutdown(UInteger value) {
        this.getVariableComponent("SecondsTillShutdown").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public LocalizedText getShutdownReason() {
        Optional<VariableNode> component = this.getVariableComponent("ShutdownReason");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getShutdownReasonNode() {
        Optional<VariableNode> component = this.getVariableComponent("ShutdownReason");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setShutdownReason(LocalizedText value) {
        this.getVariableComponent("ShutdownReason").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

