/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.SamplingIntervalDiagnosticsType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;

@UaVariableNode(typeName="0:SamplingIntervalDiagnosticsType")
public class SamplingIntervalDiagnosticsNode
extends BaseDataVariableNode
implements SamplingIntervalDiagnosticsType {
    public SamplingIntervalDiagnosticsNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public SamplingIntervalDiagnosticsNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public synchronized DataValue getValue() {
        SamplingIntervalDiagnosticsDataType value = new SamplingIntervalDiagnosticsDataType(this.getSamplingInterval(), this.getSampledMonitoredItemsCount(), this.getMaxSampledMonitoredItemsCount(), this.getDisabledMonitoredItemsSamplingCount());
        return new DataValue(new Variant(value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        super.setValue(value);
        Object o = value.getValue().getValue();
        if (o instanceof SamplingIntervalDiagnosticsDataType) {
            SamplingIntervalDiagnosticsDataType v = (SamplingIntervalDiagnosticsDataType)o;
            this.setSamplingInterval(v.getSamplingInterval());
            this.setSampledMonitoredItemsCount(v.getMonitoredItemCount());
            this.setMaxSampledMonitoredItemsCount(v.getMaxMonitoredItemCount());
            this.setDisabledMonitoredItemsSamplingCount(v.getDisabledMonitoredItemCount());
        }
    }

    @Override
    public Double getSamplingInterval() {
        Optional<VariableNode> component = this.getVariableComponent("SamplingInterval");
        return component.map(node -> (Double)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSamplingIntervalNode() {
        Optional<VariableNode> component = this.getVariableComponent("SamplingInterval");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSamplingInterval(Double value) {
        this.getVariableComponent("SamplingInterval").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getSampledMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("SampledMonitoredItemsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSampledMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SampledMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSampledMonitoredItemsCount(UInteger value) {
        this.getVariableComponent("SampledMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getMaxSampledMonitoredItemsCount() {
        Optional<VariableNode> component = this.getVariableComponent("MaxSampledMonitoredItemsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getMaxSampledMonitoredItemsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("MaxSampledMonitoredItemsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setMaxSampledMonitoredItemsCount(UInteger value) {
        this.getVariableComponent("MaxSampledMonitoredItemsCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }

    @Override
    public UInteger getDisabledMonitoredItemsSamplingCount() {
        Optional<VariableNode> component = this.getVariableComponent("DisabledMonitoredItemsSamplingCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getDisabledMonitoredItemsSamplingCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("DisabledMonitoredItemsSamplingCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setDisabledMonitoredItemsSamplingCount(UInteger value) {
        this.getVariableComponent("DisabledMonitoredItemsSamplingCount").ifPresent(n -> n.setValue(new DataValue(new Variant(value))));
    }
}

