/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.CertificateGroupFolderNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ServerConfigurationType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:ServerConfigurationType")
public class ServerConfigurationNode
extends BaseObjectNode
implements ServerConfigurationType {
    public ServerConfigurationNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerCapabilities() {
        Optional<String[]> property = this.getProperty(ServerConfigurationType.SERVER_CAPABILITIES);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getServerCapabilitiesNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerConfigurationType.SERVER_CAPABILITIES.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setServerCapabilities(String[] value) {
        this.setProperty(ServerConfigurationType.SERVER_CAPABILITIES, value);
    }

    @Override
    public String[] getSupportedPrivateKeyFormats() {
        Optional<String[]> property = this.getProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getSupportedPrivateKeyFormatsNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setSupportedPrivateKeyFormats(String[] value) {
        this.setProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS, value);
    }

    @Override
    public UInteger getMaxTrustListSize() {
        Optional<UInteger> property = this.getProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getMaxTrustListSizeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerConfigurationType.MAX_TRUST_LIST_SIZE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setMaxTrustListSize(UInteger value) {
        this.setProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE, value);
    }

    @Override
    public Boolean getMulticastDnsEnabled() {
        Optional<Boolean> property = this.getProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getMulticastDnsEnabledNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerConfigurationType.MULTICAST_DNS_ENABLED.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setMulticastDnsEnabled(Boolean value) {
        this.setProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED, value);
    }

    @Override
    public CertificateGroupFolderNode getCertificateGroupsNode() {
        Optional<ObjectNode> component = this.getObjectComponent("CertificateGroups");
        return component.map(node -> (CertificateGroupFolderNode)node).orElse(null);
    }
}

