/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.TrustListNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.CertificateGroupType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:CertificateGroupType")
public class CertificateGroupNode
extends BaseObjectNode
implements CertificateGroupType {
    public CertificateGroupNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NodeId[] getCertificateTypes() {
        Optional<NodeId[]> property = this.getProperty(CertificateGroupType.CERTIFICATE_TYPES);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getCertificateTypesNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CertificateGroupType.CERTIFICATE_TYPES.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setCertificateTypes(NodeId[] value) {
        this.setProperty(CertificateGroupType.CERTIFICATE_TYPES, value);
    }

    @Override
    public TrustListNode getTrustListNode() {
        Optional<ObjectNode> component = this.getObjectComponent("TrustList");
        return component.map(node -> (TrustListNode)node).orElse(null);
    }
}

