/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.items;

import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.BaseEventType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public class MonitoredEventItem
extends BaseMonitoredItem<Variant[]>
implements EventItem {
    private volatile EventFilter filter;

    public MonitoredEventItem(UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, UInteger queueSize, boolean discardOldest, ExtensionObject filter) throws UaException {
        super(id, subscriptionId, readValueId, monitoringMode, timestamps, clientHandle, samplingInterval, queueSize, discardOldest);
        this.installFilter(filter);
    }

    @Override
    public void setEvent(BaseEventType event) {
        Variant[] variants = new Variant[]{new Variant(event.getEventId()), new Variant(event.getEventType()), new Variant(event.getSourceNode()), new Variant(event.getSourceNode()), new Variant(event.getTime())};
        this.enqueue(variants);
    }

    @Override
    protected void enqueue(Variant[] value) {
        if (this.queueSize < this.queue.maxSize()) {
            this.queue.add(value);
        } else {
            if (this.getQueueSize() > 1) {
                // empty if block
            }
            if (this.discardOldest) {
                this.queue.add(value);
            } else {
                this.queue.set(this.queue.maxSize() - 1, value);
            }
        }
    }

    @Override
    public ExtensionObject getFilterResult() {
        return null;
    }

    @Override
    protected void installFilter(ExtensionObject filterXo) throws UaException {
    }

    protected EventFieldList wrapQueueValue(Variant[] value) {
        return new EventFieldList(Unsigned.uint(this.getClientHandle()), value);
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.getMonitoringMode() != MonitoringMode.Disabled;
    }
}

