/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.config;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;

public interface OpcUaServerConfig
extends UaTcpStackServerConfig {
    public static final UserTokenPolicy USER_TOKEN_POLICY_ANONYMOUS = new UserTokenPolicy("anonymous", UserTokenType.Anonymous, null, null, null);
    public static final UserTokenPolicy USER_TOKEN_POLICY_USERNAME = new UserTokenPolicy("username", UserTokenType.UserName, null, null, null);
    public static final UserTokenPolicy USER_TOKEN_POLICY_X509 = new UserTokenPolicy("certificate", UserTokenType.Certificate, null, null, SecurityPolicy.Basic256.getSecurityPolicyUri());

    public EnumSet<SecurityPolicy> getSecurityPolicies();

    public String getHostname();

    public List<String> getBindAddresses();

    public int getBindPort();

    public IdentityValidator getIdentityValidator();

    public BuildInfo getBuildInfo();

    public OpcUaServerConfigLimits getLimits();

    public Function<String, Set<String>> getHostnameResolver();

    public static OpcUaServerConfigBuilder builder() {
        return new OpcUaServerConfigBuilder();
    }

    public static OpcUaServerConfigBuilder copy(OpcUaServerConfig config) {
        OpcUaServerConfigBuilder builder = new OpcUaServerConfigBuilder();
        builder.setServerName(config.getServerName());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setExecutor(config.getExecutor());
        builder.setUserTokenPolicies((List)config.getUserTokenPolicies());
        builder.setSoftwareCertificates((List)config.getSoftwareCertificates());
        builder.setChannelConfig(config.getChannelConfig());
        builder.setStrictEndpointUrlsEnabled(config.isStrictEndpointUrlsEnabled());
        builder.setSecurityPolicies(config.getSecurityPolicies());
        builder.setHostname(config.getHostname());
        builder.setBindAddresses(config.getBindAddresses());
        builder.setBindPort(config.getBindPort());
        builder.setIdentityValidator(config.getIdentityValidator());
        builder.setBuildInfo(config.getBuildInfo());
        builder.setLimits(config.getLimits());
        builder.setHostnameResolver(config.getHostnameResolver());
        return builder;
    }

    public static OpcUaServerConfig copy(OpcUaServerConfig config, Consumer<OpcUaServerConfigBuilder> consumer) {
        OpcUaServerConfigBuilder builder = OpcUaServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

