/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.OperationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;

public interface NodeManager {
    default public void addNode(AddNodesContext context, List<AddNodesItem> nodesToAdd) {
        AddNodesResult result = new AddNodesResult(new StatusCode(2151481344L), NodeId.NULL_VALUE);
        context.complete(Collections.nCopies(nodesToAdd.size(), result));
    }

    default public void deleteNode(DeleteNodesContext context, List<DeleteNodesItem> nodesToDelete) {
        StatusCode statusCode = new StatusCode(2151481344L);
        context.complete(Collections.nCopies(nodesToDelete.size(), statusCode));
    }

    default public void addReference(AddReferencesContext context, List<AddReferencesItem> referencesToAdd) {
        StatusCode statusCode = new StatusCode(2151481344L);
        context.complete(Collections.nCopies(referencesToAdd.size(), statusCode));
    }

    default public void deleteReference(DeleteReferencesContext context, List<DeleteReferencesItem> referencesToDelete) {
        StatusCode statusCode = new StatusCode(2151481344L);
        context.complete(Collections.nCopies(referencesToDelete.size(), statusCode));
    }

    public static final class DeleteReferencesContext
    extends OperationContext<DeleteReferencesItem, StatusCode> {
        public DeleteReferencesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<DeleteReferencesItem> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }

    public static final class AddReferencesContext
    extends OperationContext<AddReferencesItem, StatusCode> {
        public AddReferencesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<AddReferencesItem> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }

    public static final class DeleteNodesContext
    extends OperationContext<DeleteNodesItem, StatusCode> {
        public DeleteNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<DeleteNodesItem> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }

    public static final class AddNodesContext
    extends OperationContext<AddNodesItem, AddNodesResult> {
        public AddNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<AddNodesItem> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }
}

