/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.OperationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.slf4j.LoggerFactory;

public interface MethodServices {
    default public void call(CallContext context, List<CallMethodRequest> requests) {
        ArrayList results = Lists.newArrayListWithCapacity((int)requests.size());
        for (CallMethodRequest request : requests) {
            MethodInvocationHandler handler = this.getInvocationHandler(request.getMethodId()).orElse(new MethodInvocationHandler.NodeIdUnknownHandler());
            CompletableFuture<CallMethodResult> resultFuture = new CompletableFuture<CallMethodResult>();
            try {
                handler.invoke(request, resultFuture);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(this.getClass()).error("Uncaught Throwable invoking method handler for methodId={}.", (Object)request.getMethodId(), (Object)t);
                resultFuture.complete(new CallMethodResult(new StatusCode(0x80020000L), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]));
            }
            results.add(resultFuture);
        }
        FutureUtils.sequence(results).thenAccept(rs -> context.complete(rs));
    }

    default public Optional<MethodInvocationHandler> getInvocationHandler(NodeId methodId) {
        return Optional.empty();
    }

    public static final class CallContext
    extends OperationContext<CallMethodRequest, CallMethodResult> {
        public CallContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<CallMethodRequest> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }

        public CallContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<CallMethodResult>> future, DiagnosticsContext<CallMethodRequest> diagnosticsContext) {
            super(server, session, future, diagnosticsContext);
        }
    }
}

