/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public final class NumericRange {
    private final String range;
    private final Bounds[] bounds;

    public NumericRange(String range, Bounds[] bounds) {
        this.range = range;
        this.bounds = bounds;
    }

    public String getRange() {
        return this.range;
    }

    public Bounds[] getBounds() {
        return this.bounds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)this.range).toString();
    }

    private int getDimensionCount() {
        return this.bounds.length;
    }

    private Bounds getDimensionBounds(int dimension) {
        return this.bounds[dimension - 1];
    }

    public static NumericRange parse(String range) throws UaException {
        try {
            String[] ss = range.split(",");
            Bounds[] bounds = new Bounds[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                String s = ss[i];
                String[] bs = s.split(":");
                if (bs.length == 1) {
                    int index = Integer.parseInt(bs[0]);
                    bounds[i] = new Bounds(index, index);
                    continue;
                }
                if (bs.length == 2) {
                    int high;
                    int low = Integer.parseInt(bs[0]);
                    if (low == (high = Integer.parseInt(bs[1]))) {
                        throw new UaException(2151022592L);
                    }
                    bounds[i] = new Bounds(low, high);
                    continue;
                }
                throw new UaException(2151022592L);
            }
            return new NumericRange(range, bounds);
        }
        catch (Throwable ex) {
            throw new UaException(2151022592L, ex);
        }
    }

    public static Object readFromValueAtRange(Variant value, NumericRange range) throws UaException {
        Object array = value.getValue();
        if (array == null) {
            throw new UaException(2151088128L);
        }
        if (!(array.getClass().isArray() || array instanceof String || array instanceof ByteString)) {
            throw new UaException(2151022592L);
        }
        try {
            return NumericRange.readFromValueAtRange(array, range, 1);
        }
        catch (Throwable ex) {
            throw new UaException(2151088128L, ex);
        }
    }

    private static Object readFromValueAtRange(Object array, NumericRange range, int dimension) throws UaException {
        int dimensionCount = range.getDimensionCount();
        Bounds bounds = range.getDimensionBounds(dimension);
        int low = bounds.low;
        int high = bounds.high;
        if (dimension == dimensionCount) {
            if (array.getClass().isArray()) {
                int len = Math.min(high - low + 1, Array.getLength(array));
                Class<?> type = array.getClass().getComponentType();
                Object a = Array.newInstance(type, len);
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(array, low + i);
                    Array.set(a, i, element);
                }
                return a;
            }
            if (array instanceof String) {
                String s = (String)array;
                int to = Math.min(high + 1, s.length());
                return s.substring(low, to);
            }
            if (array instanceof ByteString) {
                ByteString bs = (ByteString)array;
                int to = Math.min(high + 1, bs.length());
                byte[] copy = Arrays.copyOfRange(bs.bytesOrEmpty(), low, to);
                return new ByteString(copy);
            }
            throw new UaException(2151088128L);
        }
        int len = Math.min(high - low + 1, Array.getLength(array));
        Class<?> type = array.getClass().getComponentType();
        Object a = Array.newInstance(type, len);
        for (int i = 0; i < len; ++i) {
            Object na = Array.get(array, low + i);
            Object element = NumericRange.readFromValueAtRange(na, range, dimension + 1);
            Array.set(a, i, element);
        }
        return a;
    }

    public static Object writeToValueAtRange(Variant currentVariant, Variant updateVariant, NumericRange range) throws UaException {
        Object current = currentVariant.getValue();
        Object update = updateVariant.getValue();
        if (current == null || update == null) {
            throw new UaException(2151088128L);
        }
        try {
            return NumericRange.writeToValueAtRange(current, update, range, 1);
        }
        catch (Throwable ex) {
            throw new UaException(2151088128L, ex);
        }
    }

    private static Object writeToValueAtRange(Object current, Object update, NumericRange range, int dimension) throws UaException {
        int dimensionCount = range.getDimensionCount();
        Bounds bounds = range.getDimensionBounds(dimension);
        int low = bounds.low;
        int high = bounds.high;
        if (dimension == dimensionCount) {
            if (current.getClass().isArray()) {
                Class<?> type = current.getClass().getComponentType();
                int length = Array.getLength(current);
                Object copy = Array.newInstance(type, length);
                if (low >= length || high >= length) {
                    throw new UaException(2151088128L);
                }
                for (int i = 0; i < length; ++i) {
                    Object element;
                    if (i < low || i > high) {
                        element = Array.get(current, i);
                        Array.set(copy, i, element);
                        continue;
                    }
                    element = Array.get(update, i - low);
                    Array.set(copy, i, element);
                }
                return copy;
            }
            if (current instanceof String) {
                String cs = (String)current;
                String us = (String)update;
                int length = cs.length();
                StringBuilder copy = new StringBuilder();
                if (low >= length || high >= length) {
                    throw new UaException(2151088128L);
                }
                for (int i = 0; i < length; ++i) {
                    if (i < low || i > high) {
                        copy.append(cs.charAt(i));
                        continue;
                    }
                    copy.append(us.charAt(i - low));
                }
                return copy.toString();
            }
            if (current instanceof ByteString) {
                ByteString bs = (ByteString)current;
                ByteString us = (ByteString)update;
                int length = bs.length();
                byte[] copy = new byte[length];
                if (low >= length || high >= length) {
                    throw new UaException(2151088128L);
                }
                for (int i = 0; i < length; ++i) {
                    copy[i] = i < low || i > high ? bs.byteAt(i) : us.byteAt(i - low);
                }
                return new ByteString(copy);
            }
            throw new UaException(2151088128L);
        }
        Class<?> type = current.getClass().getComponentType();
        int length = Array.getLength(current);
        Object copy = Array.newInstance(type, length);
        if (low >= length || high >= length) {
            throw new UaException(2151088128L);
        }
        for (int i = 0; i < length; ++i) {
            if (i < low || i > high) {
                Object element = Array.get(current, i);
                Array.set(copy, i, element);
                continue;
            }
            Object c = Array.get(current, i);
            Object u = Array.get(update, i - low);
            Object element = NumericRange.writeToValueAtRange(c, u, range, dimension + 1);
            Array.set(copy, i, element);
        }
        return copy;
    }

    public static final class Bounds {
        private final int low;
        private final int high;

        private Bounds(int low, int high) throws UaException {
            if (low < 0 || high < 0 || low > high) {
                throw new UaException(2151022592L);
            }
            this.low = low;
            this.high = high;
        }
    }
}

