/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class UaObjectNode
extends UaNode
implements ObjectNode {
    public UaObjectNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<? extends Node> getComponent(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.Object.getValue() | NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasComponent, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals(r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().createNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    public CompletableFuture<? extends ObjectNode> getObjectComponent(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.Object.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasComponent, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals(r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().getObjectNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    public CompletableFuture<? extends VariableNode> getVariableComponent(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasComponent, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals(r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().getVariableNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    public CompletableFuture<? extends ObjectTypeNode> getTypeDefinition() {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.ObjectType.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasTypeDefinition, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().flatMap(r -> {
                Optional<ObjectTypeNode> opt = r.getNodeId().local().map(id -> this.client.getAddressSpace().createObjectTypeNode((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.map(CompletableFuture::completedFuture).orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    @Override
    public CompletableFuture<UByte> getEventNotifier() {
        return this.getAttributeOrFail(this.readEventNotifier());
    }

    @Override
    public CompletableFuture<StatusCode> setEventNotifier(UByte eventNotifier) {
        return this.writeEventNotifier(DataValue.valueOnly(new Variant(eventNotifier)));
    }

    @Override
    public CompletableFuture<DataValue> readEventNotifier() {
        return this.readAttribute(AttributeId.EventNotifier);
    }

    @Override
    public CompletableFuture<StatusCode> writeEventNotifier(DataValue value) {
        return this.writeAttribute(AttributeId.EventNotifier, value);
    }
}

