/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.NodeCache;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.core.model.Property;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.DecoderDelegate;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.binary.BinaryDecoder;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public abstract class UaNode
implements Node {
    protected final NodeCache nodeCache;
    protected final OpcUaClient client;
    protected final NodeId nodeId;

    public UaNode(OpcUaClient client, NodeId nodeId) {
        this.client = client;
        this.nodeId = nodeId;
        this.nodeCache = client.getNodeCache();
    }

    protected CompletableFuture<PropertyNode> getPropertyNode(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint(NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint(BrowseResultMask.BrowseName.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasProperty, false, nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List<ReferenceDescription> references = ConversionUtil.l(result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals(r.getBrowseName())).flatMap(r -> {
                Optional<PropertyNode> opt = r.getNodeId().local().map(id -> new PropertyNode(this.client, (NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.map(CompletableFuture::completedFuture).orElse(FutureUtils.failedUaFuture(2151546880L));
        });
    }

    protected <T> CompletableFuture<T> getProperty(Property<T> property) {
        return ((CompletableFuture)this.getPropertyNode(property.getBrowseName()).thenCompose(VariableNode::getValue)).thenApply(value -> property.getJavaType().cast(value));
    }

    protected CompletableFuture<DataValue> readProperty(Property<?> property) {
        return this.getPropertyNode(property.getBrowseName()).thenCompose(VariableNode::readValue);
    }

    protected <T> CompletableFuture<StatusCode> setProperty(Property<T> property, T value) {
        return this.getPropertyNode(property.getBrowseName()).thenCompose(node -> node.setValue(value));
    }

    protected CompletableFuture<StatusCode> writeProperty(Property<?> property, DataValue value) {
        return this.getPropertyNode(property.getBrowseName()).thenCompose(node -> node.writeValue(value));
    }

    protected CompletableFuture<DataValue> readAttribute(AttributeId attributeId) {
        Optional<DataValue> opt = AttributeId.BASE_NODE_ATTRIBUTES.contains((Object)attributeId) ? this.nodeCache.getAttribute(this.nodeId, attributeId) : Optional.empty();
        return opt.map(CompletableFuture::completedFuture).orElseGet(() -> {
            ReadValueId readValueId = new ReadValueId(this.nodeId, attributeId.uid(), null, QualifiedName.NULL_VALUE);
            CompletableFuture<ReadResponse> future = this.client.read(0.0, TimestampsToReturn.Both, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
            return future.thenApply(response -> {
                DataValue value = ConversionUtil.l(response.getResults()).get(0);
                if (attributeId != AttributeId.Value) {
                    this.nodeCache.putAttribute(this.nodeId, attributeId, value);
                }
                return value;
            });
        });
    }

    protected CompletableFuture<StatusCode> writeAttribute(AttributeId attributeId, DataValue value) {
        WriteValue writeValue = new WriteValue(this.nodeId, attributeId.uid(), null, value);
        return this.client.write(Lists.newArrayList((Object[])new WriteValue[]{writeValue})).thenApply(response -> {
            StatusCode statusCode = ConversionUtil.l(response.getResults()).get(0);
            if (statusCode.isGood()) {
                this.nodeCache.invalidate(this.nodeId, attributeId);
            }
            return statusCode;
        });
    }

    protected <T> CompletableFuture<T> getAttributeOrFail(CompletableFuture<DataValue> readFuture) {
        return readFuture.thenCompose(value -> {
            if (value.getStatusCode().isGood()) {
                try {
                    return CompletableFuture.completedFuture(value.getValue().getValue());
                }
                catch (Throwable t) {
                    return FutureUtils.failedUaFuture(t, 2155085824L);
                }
            }
            return FutureUtils.failedUaFuture(value.getStatusCode());
        });
    }

    @Override
    public CompletableFuture<NodeId> getNodeId() {
        return this.getAttributeOrFail(this.readNodeId());
    }

    @Override
    public CompletableFuture<NodeClass> getNodeClass() {
        return this.getAttributeOrFail(this.readNodeClass()).thenApply(NodeClass::from);
    }

    @Override
    public CompletableFuture<QualifiedName> getBrowseName() {
        return this.getAttributeOrFail(this.readBrowseName());
    }

    @Override
    public CompletableFuture<LocalizedText> getDisplayName() {
        return this.getAttributeOrFail(this.readDisplayName());
    }

    @Override
    public CompletableFuture<LocalizedText> getDescription() {
        return this.getAttributeOrFail(this.readDescription());
    }

    @Override
    public CompletableFuture<UInteger> getWriteMask() {
        return this.getAttributeOrFail(this.readWriteMask());
    }

    @Override
    public CompletableFuture<UInteger> getUserWriteMask() {
        return this.getAttributeOrFail(this.readUserWriteMask());
    }

    @Override
    public CompletableFuture<StatusCode> setNodeId(NodeId nodeId) {
        return this.writeNodeId(DataValue.valueOnly(new Variant(nodeId)));
    }

    @Override
    public CompletableFuture<StatusCode> setNodeClass(NodeClass nodeClass) {
        return this.writeNodeClass(DataValue.valueOnly(new Variant(nodeClass)));
    }

    @Override
    public CompletableFuture<StatusCode> setBrowseName(QualifiedName browseName) {
        return this.writeBrowseName(DataValue.valueOnly(new Variant(browseName)));
    }

    @Override
    public CompletableFuture<StatusCode> setDisplayName(LocalizedText displayName) {
        return this.writeDisplayName(DataValue.valueOnly(new Variant(displayName)));
    }

    @Override
    public CompletableFuture<StatusCode> setDescription(LocalizedText description) {
        return this.writeDescription(DataValue.valueOnly(new Variant(description)));
    }

    @Override
    public CompletableFuture<StatusCode> setWriteMask(UInteger writeMask) {
        return this.writeWriteMask(DataValue.valueOnly(new Variant(writeMask)));
    }

    @Override
    public CompletableFuture<StatusCode> setUserWriteMask(UInteger userWriteMask) {
        return this.writeUserWriteMask(DataValue.valueOnly(new Variant(userWriteMask)));
    }

    @Override
    public CompletableFuture<DataValue> readNodeId() {
        return this.readAttribute(AttributeId.NodeId);
    }

    @Override
    public CompletableFuture<DataValue> readNodeClass() {
        return this.readAttribute(AttributeId.NodeClass);
    }

    @Override
    public CompletableFuture<DataValue> readBrowseName() {
        return this.readAttribute(AttributeId.BrowseName);
    }

    @Override
    public CompletableFuture<DataValue> readDisplayName() {
        return this.readAttribute(AttributeId.DisplayName);
    }

    @Override
    public CompletableFuture<DataValue> readDescription() {
        return this.readAttribute(AttributeId.Description);
    }

    @Override
    public CompletableFuture<DataValue> readWriteMask() {
        return this.readAttribute(AttributeId.WriteMask);
    }

    @Override
    public CompletableFuture<DataValue> readUserWriteMask() {
        return this.readAttribute(AttributeId.UserWriteMask);
    }

    @Override
    public CompletableFuture<StatusCode> writeNodeId(DataValue value) {
        return this.writeAttribute(AttributeId.NodeId, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeNodeClass(DataValue value) {
        return this.writeAttribute(AttributeId.NodeClass, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeBrowseName(DataValue value) {
        return this.writeAttribute(AttributeId.BrowseName, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeDisplayName(DataValue value) {
        return this.writeAttribute(AttributeId.DisplayName, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeDescription(DataValue value) {
        return this.writeAttribute(AttributeId.Description, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeWriteMask(DataValue value) {
        return this.writeAttribute(AttributeId.WriteMask, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeUserWriteMask(DataValue value) {
        return this.writeAttribute(AttributeId.UserWriteMask, value);
    }

    protected static <T> T cast(Object o, Class<T> clazz) {
        if (UaEnumeration.class.isAssignableFrom(clazz) && o instanceof Integer) {
            return DelegateRegistry.getInstance().getDecoder(clazz).decode(new EnumDecoder((Integer)o));
        }
        if (UaStructure.class.isAssignableFrom(clazz) && o instanceof ExtensionObject) {
            Object decoded = ((ExtensionObject)o).decode();
            return clazz.cast(decoded);
        }
        return clazz.cast(o);
    }

    private static class EnumDecoder
    extends BinaryDecoder {
        private final int value;

        EnumDecoder(int value) {
            this.value = value;
        }

        @Override
        public Integer decodeInt32(String field) throws UaSerializationException {
            return this.value;
        }

        @Override
        public <T extends UaEnumeration> T decodeEnumeration(String field, Class<T> clazz) throws UaSerializationException {
            DecoderDelegate<T> delegate = DelegateRegistry.getInstance().getDecoder(clazz);
            return (T)((UaEnumeration)delegate.decode(this));
        }
    }
}

