/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.NamespacesNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerCapabilitiesNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerDiagnosticsNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerRedundancyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.VendorServerInfoNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerStatusNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;

public class ServerNode
extends BaseObjectNode
implements ServerType {
    public ServerNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> serverArray() {
        return this.getPropertyNode(ServerType.SERVER_ARRAY.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getServerArray() {
        return this.getProperty(ServerType.SERVER_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setServerArray(String[] value) {
        return this.setProperty(ServerType.SERVER_ARRAY, value);
    }

    public CompletableFuture<PropertyNode> namespaceArray() {
        return this.getPropertyNode(ServerType.NAMESPACE_ARRAY.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getNamespaceArray() {
        return this.getProperty(ServerType.NAMESPACE_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setNamespaceArray(String[] value) {
        return this.setProperty(ServerType.NAMESPACE_ARRAY, value);
    }

    public CompletableFuture<PropertyNode> serviceLevel() {
        return this.getPropertyNode(ServerType.SERVICE_LEVEL.getBrowseName());
    }

    @Override
    public CompletableFuture<UByte> getServiceLevel() {
        return this.getProperty(ServerType.SERVICE_LEVEL);
    }

    @Override
    public CompletableFuture<StatusCode> setServiceLevel(UByte value) {
        return this.setProperty(ServerType.SERVICE_LEVEL, value);
    }

    public CompletableFuture<PropertyNode> auditing() {
        return this.getPropertyNode(ServerType.AUDITING.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getAuditing() {
        return this.getProperty(ServerType.AUDITING);
    }

    @Override
    public CompletableFuture<StatusCode> setAuditing(Boolean value) {
        return this.setProperty(ServerType.AUDITING, value);
    }

    public CompletableFuture<PropertyNode> estimatedReturnTime() {
        return this.getPropertyNode(ServerType.ESTIMATED_RETURN_TIME.getBrowseName());
    }

    @Override
    public CompletableFuture<DateTime> getEstimatedReturnTime() {
        return this.getProperty(ServerType.ESTIMATED_RETURN_TIME);
    }

    @Override
    public CompletableFuture<StatusCode> setEstimatedReturnTime(DateTime value) {
        return this.setProperty(ServerType.ESTIMATED_RETURN_TIME, value);
    }

    public CompletableFuture<ServerStatusNode> serverStatus() {
        return this.getVariableComponent(QualifiedName.parse("0:ServerStatus")).thenApply(ServerStatusNode.class::cast);
    }

    @Override
    public CompletableFuture<ServerStatusDataType> getServerStatus() {
        return ((CompletableFuture)this.serverStatus().thenCompose(UaVariableNode::getValue)).thenApply(o -> ServerNode.cast(o, ServerStatusDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setServerStatus(ServerStatusDataType value) {
        return this.serverStatus().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ServerCapabilitiesNode> serverCapabilities() {
        return this.getObjectComponent(QualifiedName.parse("0:ServerCapabilities")).thenApply(ServerCapabilitiesNode.class::cast);
    }

    public CompletableFuture<ServerDiagnosticsNode> serverDiagnostics() {
        return this.getObjectComponent(QualifiedName.parse("0:ServerDiagnostics")).thenApply(ServerDiagnosticsNode.class::cast);
    }

    public CompletableFuture<VendorServerInfoNode> vendorServerInfo() {
        return this.getObjectComponent(QualifiedName.parse("0:VendorServerInfo")).thenApply(VendorServerInfoNode.class::cast);
    }

    public CompletableFuture<ServerRedundancyNode> serverRedundancy() {
        return this.getObjectComponent(QualifiedName.parse("0:ServerRedundancy")).thenApply(ServerRedundancyNode.class::cast);
    }

    public CompletableFuture<NamespacesNode> namespaces() {
        return this.getObjectComponent(QualifiedName.parse("0:Namespaces")).thenApply(NamespacesNode.class::cast);
    }
}

