/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AcknowledgeableConditionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ShelvedStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AlarmConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class AlarmConditionNode
extends AcknowledgeableConditionNode
implements AlarmConditionType {
    public AlarmConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> inputNode() {
        return this.getPropertyNode(AlarmConditionType.INPUT_NODE.getBrowseName());
    }

    @Override
    public CompletableFuture<NodeId> getInputNode() {
        return this.getProperty(AlarmConditionType.INPUT_NODE);
    }

    @Override
    public CompletableFuture<StatusCode> setInputNode(NodeId value) {
        return this.setProperty(AlarmConditionType.INPUT_NODE, value);
    }

    public CompletableFuture<PropertyNode> suppressedOrShelved() {
        return this.getPropertyNode(AlarmConditionType.SUPPRESSED_OR_SHELVED.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getSuppressedOrShelved() {
        return this.getProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED);
    }

    @Override
    public CompletableFuture<StatusCode> setSuppressedOrShelved(Boolean value) {
        return this.setProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED, value);
    }

    public CompletableFuture<PropertyNode> maxTimeShelved() {
        return this.getPropertyNode(AlarmConditionType.MAX_TIME_SHELVED.getBrowseName());
    }

    @Override
    public CompletableFuture<Double> getMaxTimeShelved() {
        return this.getProperty(AlarmConditionType.MAX_TIME_SHELVED);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxTimeShelved(Double value) {
        return this.setProperty(AlarmConditionType.MAX_TIME_SHELVED, value);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> enabledState() {
        return this.getVariableComponent(QualifiedName.parse("0:EnabledState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.enabledState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AlarmConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.enabledState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> activeState() {
        return this.getVariableComponent(QualifiedName.parse("0:ActiveState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getActiveState() {
        return ((CompletableFuture)this.activeState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AlarmConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setActiveState(LocalizedText value) {
        return this.activeState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> suppressedState() {
        return this.getVariableComponent(QualifiedName.parse("0:SuppressedState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getSuppressedState() {
        return ((CompletableFuture)this.suppressedState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AlarmConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setSuppressedState(LocalizedText value) {
        return this.suppressedState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ShelvedStateMachineNode> shelvingState() {
        return this.getObjectComponent(QualifiedName.parse("0:ShelvingState")).thenApply(ShelvedStateMachineNode.class::cast);
    }
}

