/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public class PartialNodeId {
    private IdType type;
    private final Serializable id;

    public PartialNodeId(int id) {
        this(Unsigned.uint(id));
    }

    public PartialNodeId(UInteger id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    public PartialNodeId(String id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    public PartialNodeId(UUID id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    public PartialNodeId(ByteString id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    public NodeId toNodeId(int namespaceIndex) {
        if (this.id instanceof String) {
            return new NodeId(namespaceIndex, (String)((Object)this.id));
        }
        if (this.id instanceof UInteger) {
            return new NodeId(Unsigned.ushort(namespaceIndex), (UInteger)this.id);
        }
        if (this.id instanceof ByteString) {
            return new NodeId(namespaceIndex, (ByteString)this.id);
        }
        if (this.id instanceof UUID) {
            return new NodeId(namespaceIndex, (UUID)this.id);
        }
        throw new IllegalStateException("Invalid id type: " + this.id);
    }

    public NodeId toNodeId(UShort namespaceIndex) {
        if (this.id instanceof String) {
            return new NodeId(namespaceIndex, (String)((Object)this.id));
        }
        if (this.id instanceof UInteger) {
            return new NodeId(namespaceIndex, (UInteger)this.id);
        }
        if (this.id instanceof ByteString) {
            return new NodeId(namespaceIndex, (ByteString)this.id);
        }
        if (this.id instanceof UUID) {
            return new NodeId(namespaceIndex, (UUID)this.id);
        }
        throw new IllegalStateException("Invalid id type: " + this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("id", (Object)this.id).toString();
    }

    public Serializable getValue() {
        return this.id;
    }

    public static PartialNodeId fromExpandedNodeId(ExpandedNodeId node) {
        if (node == null) {
            return null;
        }
        Object value = node.getIdentifier();
        if (value instanceof String) {
            return new PartialNodeId((String)value);
        }
        if (value instanceof UInteger) {
            return new PartialNodeId((UInteger)value);
        }
        if (value instanceof UUID) {
            return new PartialNodeId((UUID)value);
        }
        if (value instanceof ByteString) {
            return new PartialNodeId((ByteString)value);
        }
        throw new IllegalStateException(String.format("Unknown node id type: " + value, new Object[0]));
    }
}

