/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class NamespaceId {
    private final String uri;
    private final UShort numeric;

    public NamespaceId(String uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
        this.numeric = null;
    }

    public NamespaceId(UShort numeric) {
        Objects.requireNonNull(numeric);
        this.uri = null;
        this.numeric = numeric;
    }

    public String getUri() {
        return this.uri;
    }

    public UShort getNumeric() {
        return this.numeric;
    }

    public boolean isNumeric() {
        return this.numeric != null;
    }

    public String toString() {
        if (this.isNumeric()) {
            return String.format("[Namespace - numeric: %s]", this.numeric);
        }
        return String.format("[Namespace - URI: %s]", this.uri);
    }

    public Serializable getValue() {
        return this.uri != null ? this.uri : this.numeric;
    }

    public static NamespaceId fromExpandedNodeId(ExpandedNodeId id) {
        if (id == null) {
            return null;
        }
        if (id.getNamespaceUri() != null) {
            return new NamespaceId(id.getNamespaceUri());
        }
        if (id.getNamespaceIndex() != null) {
            return new NamespaceId(id.getNamespaceIndex());
        }
        throw new IllegalStateException(String.format("Unknown namespace type", new Object[0]));
    }
}

