/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;

public class UaTcpStackServerConfigBuilder {
    private String serverName = "";
    private LocalizedText applicationName = LocalizedText.english("server application name not configured");
    private String applicationUri = "server application uri not configured";
    private String productUri = "server product uri not configured";
    private ChannelConfig channelConfig = ChannelConfig.DEFAULT;
    private boolean strictEndpointUrlsEnabled = true;
    private CertificateManager certificateManager;
    private CertificateValidator certificateValidator;
    private ExecutorService executor;
    private List<UserTokenPolicy> userTokenPolicies = new ArrayList<UserTokenPolicy>();
    private List<SignedSoftwareCertificate> softwareCertificates = new ArrayList<SignedSoftwareCertificate>();

    public UaTcpStackServerConfigBuilder setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public UaTcpStackServerConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public UaTcpStackServerConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public UaTcpStackServerConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public UaTcpStackServerConfigBuilder setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
        return this;
    }

    public UaTcpStackServerConfigBuilder setCertificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public UaTcpStackServerConfigBuilder setUserTokenPolicies(List<UserTokenPolicy> userTokenPolicies) {
        this.userTokenPolicies = userTokenPolicies;
        return this;
    }

    public UaTcpStackServerConfigBuilder setSoftwareCertificates(List<SignedSoftwareCertificate> softwareCertificates) {
        this.softwareCertificates = softwareCertificates;
        return this;
    }

    public UaTcpStackServerConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public UaTcpStackServerConfigBuilder setChannelConfig(ChannelConfig channelConfig) {
        this.channelConfig = channelConfig;
        return this;
    }

    public UaTcpStackServerConfigBuilder setStrictEndpointUrlsEnabled(boolean strictEndpointUrlsEnabled) {
        this.strictEndpointUrlsEnabled = strictEndpointUrlsEnabled;
        return this;
    }

    public UaTcpStackServerConfig build() {
        Preconditions.checkNotNull((Object)this.certificateManager, (Object)"certificateManager must be non-null");
        Preconditions.checkNotNull((Object)this.certificateValidator, (Object)"certificateValidator must be non-null");
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        return new UaTcpStackServerConfigImpl(this.serverName, this.applicationName, this.applicationUri, this.productUri, this.channelConfig, this.strictEndpointUrlsEnabled, this.certificateManager, this.certificateValidator, this.executor, this.userTokenPolicies, this.softwareCertificates);
    }

    private static class UaTcpStackServerConfigImpl
    implements UaTcpStackServerConfig {
        private final String serverName;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final ChannelConfig channelConfig;
        private final boolean strictEndpointUrlsEnabled;
        private final CertificateManager certificateManager;
        private final CertificateValidator certificateValidator;
        private final ExecutorService executor;
        private final List<UserTokenPolicy> userTokenPolicies;
        private final List<SignedSoftwareCertificate> softwareCertificates;

        public UaTcpStackServerConfigImpl(String serverName, LocalizedText applicationName, String applicationUri, String productUri, ChannelConfig channelConfig, boolean strictEndpointUrlsEnabled, CertificateManager certificateManager, CertificateValidator certificateValidator, ExecutorService executor, List<UserTokenPolicy> userTokenPolicies, List<SignedSoftwareCertificate> softwareCertificates) {
            this.serverName = serverName;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.channelConfig = channelConfig;
            this.strictEndpointUrlsEnabled = strictEndpointUrlsEnabled;
            this.certificateManager = certificateManager;
            this.certificateValidator = certificateValidator;
            this.executor = executor;
            this.userTokenPolicies = userTokenPolicies;
            this.softwareCertificates = softwareCertificates;
        }

        @Override
        public String getServerName() {
            return this.serverName;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public ChannelConfig getChannelConfig() {
            return this.channelConfig;
        }

        @Override
        public boolean isStrictEndpointUrlsEnabled() {
            return this.strictEndpointUrlsEnabled;
        }

        @Override
        public CertificateManager getCertificateManager() {
            return this.certificateManager;
        }

        @Override
        public CertificateValidator getCertificateValidator() {
            return this.certificateValidator;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public List<UserTokenPolicy> getUserTokenPolicies() {
            return this.userTokenPolicies;
        }

        @Override
        public List<SignedSoftwareCertificate> getSoftwareCertificates() {
            return this.softwareCertificates;
        }
    }
}

