/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.config;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfigBuilder;

public interface UaTcpStackServerConfig {
    public String getServerName();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public CertificateManager getCertificateManager();

    public CertificateValidator getCertificateValidator();

    public ExecutorService getExecutor();

    public List<UserTokenPolicy> getUserTokenPolicies();

    public List<SignedSoftwareCertificate> getSoftwareCertificates();

    public ChannelConfig getChannelConfig();

    public boolean isStrictEndpointUrlsEnabled();

    public static UaTcpStackServerConfigBuilder builder() {
        return new UaTcpStackServerConfigBuilder();
    }

    public static UaTcpStackServerConfigBuilder copy(UaTcpStackServerConfig config) {
        UaTcpStackServerConfigBuilder builder = new UaTcpStackServerConfigBuilder();
        builder.setServerName(config.getServerName());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setExecutor(config.getExecutor());
        builder.setUserTokenPolicies(config.getUserTokenPolicies());
        builder.setSoftwareCertificates(config.getSoftwareCertificates());
        builder.setChannelConfig(config.getChannelConfig());
        builder.setStrictEndpointUrlsEnabled(config.isStrictEndpointUrlsEnabled());
        return builder;
    }

    public static UaTcpStackServerConfig copy(UaTcpStackServerConfig config, Consumer<UaTcpStackServerConfigBuilder> consumer) {
        UaTcpStackServerConfigBuilder builder = UaTcpStackServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

