/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;

public class Endpoint {
    private final URI endpointUri;
    private final SecurityPolicy securityPolicy;
    private final MessageSecurityMode messageSecurity;
    private final X509Certificate certificate;
    private final String bindAddress;

    public Endpoint(@Nonnull URI endpointUri, @Nullable String bindAddress, @Nullable X509Certificate certificate, @Nonnull SecurityPolicy securityPolicy, @Nonnull MessageSecurityMode messageSecurity) {
        Preconditions.checkNotNull((Object)endpointUri);
        Preconditions.checkNotNull((Object)((Object)securityPolicy));
        Preconditions.checkNotNull((Object)messageSecurity);
        this.endpointUri = endpointUri;
        this.securityPolicy = securityPolicy;
        this.messageSecurity = messageSecurity;
        this.certificate = certificate;
        this.bindAddress = bindAddress;
    }

    public URI getEndpointUri() {
        return this.endpointUri;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurityMode getMessageSecurity() {
        return this.messageSecurity;
    }

    public Optional<X509Certificate> getCertificate() {
        return Optional.ofNullable(this.certificate);
    }

    public Optional<String> getBindAddress() {
        return Optional.ofNullable(this.bindAddress);
    }

    public short getSecurityLevel() {
        short securityLevel = 0;
        switch (this.messageSecurity) {
            case SignAndEncrypt: {
                securityLevel = (short)(securityLevel | 0x80);
                break;
            }
            case Sign: {
                securityLevel = (short)(securityLevel | 0x40);
                break;
            }
            default: {
                securityLevel = (short)(securityLevel | 0x20);
            }
        }
        switch (this.securityPolicy) {
            case Basic256Sha256: {
                securityLevel = (short)(securityLevel | 8);
                break;
            }
            case Basic256: {
                securityLevel = (short)(securityLevel | 4);
                break;
            }
            case Basic128Rsa15: {
                securityLevel = (short)(securityLevel | 2);
                break;
            }
            case None: {
                securityLevel = (short)(securityLevel | 1);
                break;
            }
        }
        return securityLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        if (this.bindAddress != null) {
            if (!this.bindAddress.equals(endpoint.bindAddress)) {
                return false;
            }
        } else if (endpoint.bindAddress != null) return false;
        if (this.certificate != null) {
            if (!this.certificate.equals(endpoint.certificate)) {
                return false;
            }
        } else if (endpoint.certificate != null) return false;
        if (!this.endpointUri.equals(endpoint.endpointUri)) return false;
        if (this.messageSecurity != endpoint.messageSecurity) return false;
        if (this.securityPolicy != endpoint.securityPolicy) return false;
        return true;
    }

    public int hashCode() {
        int result = this.endpointUri.hashCode();
        result = 31 * result + this.securityPolicy.hashCode();
        result = 31 * result + this.messageSecurity.hashCode();
        result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
        result = 31 * result + (this.bindAddress != null ? this.bindAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Endpoint{endpointUri=" + this.endpointUri + ", securityPolicy=" + (Object)((Object)this.securityPolicy) + ", messageSecurity=" + this.messageSecurity + ", certificate=" + this.certificate + ", bindAddress='" + this.bindAddress + '\'' + '}';
    }
}

