/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public class TypeUtil {
    private static final BiMap<Class<?>, Integer> PRIMITIVE_BUILTIN_TYPES = ImmutableBiMap.builder().put(Boolean.TYPE, (Object)1).put(Byte.TYPE, (Object)2).put(Short.TYPE, (Object)4).put(Integer.TYPE, (Object)6).put(Long.TYPE, (Object)8).put(Float.TYPE, (Object)10).put(Double.TYPE, (Object)11).build();
    private static final BiMap<Integer, Class<?>> BUILTIN_TYPES = ImmutableBiMap.builder().put((Object)1, Boolean.class).put((Object)2, Byte.class).put((Object)3, UByte.class).put((Object)4, Short.class).put((Object)5, UShort.class).put((Object)6, Integer.class).put((Object)7, UInteger.class).put((Object)8, Long.class).put((Object)9, ULong.class).put((Object)10, Float.class).put((Object)11, Double.class).put((Object)12, String.class).put((Object)13, DateTime.class).put((Object)14, UUID.class).put((Object)15, ByteString.class).put((Object)16, XmlElement.class).put((Object)17, NodeId.class).put((Object)18, ExpandedNodeId.class).put((Object)19, StatusCode.class).put((Object)20, QualifiedName.class).put((Object)21, LocalizedText.class).put((Object)22, ExtensionObject.class).put((Object)23, DataValue.class).put((Object)24, Variant.class).put((Object)25, DiagnosticInfo.class).build();
    private static final Map<Integer, Class<?>> SIMPLE_TYPES = ImmutableMap.builder().put((Object)TypeUtil.id(Identifiers.LocaleId), String.class).put((Object)TypeUtil.id(Identifiers.Duration), Double.class).put((Object)TypeUtil.id(Identifiers.ImageBMP), ByteString.class).put((Object)TypeUtil.id(Identifiers.ImageGIF), ByteString.class).put((Object)TypeUtil.id(Identifiers.ImageJPG), ByteString.class).put((Object)TypeUtil.id(Identifiers.ImagePNG), ByteString.class).put((Object)TypeUtil.id(Identifiers.Integer), Number.class).put((Object)TypeUtil.id(Identifiers.Number), Number.class).put((Object)TypeUtil.id(Identifiers.UtcTime), DateTime.class).build();

    private static int id(NodeId nodeId) {
        return ((UInteger)nodeId.getIdentifier()).intValue();
    }

    public static int getBuiltinTypeId(Class<?> backingType) {
        if (backingType.isPrimitive()) {
            return (Integer)PRIMITIVE_BUILTIN_TYPES.getOrDefault(backingType, (Object)-1);
        }
        return (Integer)BUILTIN_TYPES.inverse().getOrDefault(backingType, (Object)-1);
    }

    public static Class<?> getBackingClass(int typeId) {
        return (Class)BUILTIN_TYPES.get((Object)typeId);
    }

    public static Class<?> getBackingClass(ExpandedNodeId typeId) {
        if (typeId.getNamespaceIndex().intValue() == 0 && typeId.getType() == IdType.Numeric) {
            int id = ((Number)typeId.getIdentifier()).intValue();
            Class<?> c = TypeUtil.getBackingClass(id);
            return c != null ? c : SIMPLE_TYPES.get(id);
        }
        return null;
    }
}

