/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;

public class NonceUtil {
    private static volatile boolean secureRandomEnabled = false;
    private static volatile SecureRandom secureRandom;

    public static void enableSecureRandom() {
        secureRandomEnabled = true;
    }

    public static void disableSecureRandom() {
        secureRandomEnabled = false;
    }

    public static boolean isSecureRandomEnabled() {
        return secureRandomEnabled;
    }

    public static ByteString generateNonce(int length) {
        if (length == 0) {
            return ByteString.NULL_VALUE;
        }
        byte[] bs = new byte[length];
        if (secureRandom != null && secureRandomEnabled) {
            secureRandom.nextBytes(bs);
        } else {
            ThreadLocalRandom.current().nextBytes(bs);
        }
        return new ByteString(bs);
    }

    public static ByteString generateNonce(SecurityAlgorithm algorithm) {
        return NonceUtil.generateNonce(NonceUtil.getNonceLength(algorithm));
    }

    public static int getNonceLength(SecurityAlgorithm algorithm) {
        switch (algorithm) {
            case Aes128: {
                return 16;
            }
            case Aes256: {
                return 32;
            }
        }
        return 0;
    }

    static {
        new Thread(() -> {
            SecureRandom sr;
            try {
                sr = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e) {
                sr = new SecureRandom();
            }
            sr.nextBytes(new byte[32]);
            secureRandom = sr;
        }, "SecureRandomGetInstanceStrong").start();
    }
}

