/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.lang.reflect.Field;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoRestrictions {
    private static volatile boolean removed = false;

    public static synchronized boolean remove() {
        return removed;
    }

    private static boolean removeCryptographyRestrictions() {
        Logger logger = LoggerFactory.getLogger(Stack.class);
        if (CryptoRestrictions.isRestrictedCryptography()) {
            try {
                Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
                Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
                Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
                Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
                isRestrictedField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
                isRestrictedField.set(null, false);
                Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
                defaultPolicyField.setAccessible(true);
                PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
                Field perms = cryptoPermissions.getDeclaredField("perms");
                perms.setAccessible(true);
                ((Map)perms.get(defaultPolicy)).clear();
                Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
                instance.setAccessible(true);
                defaultPolicy.add((Permission)instance.get(null));
                logger.info("Successfully removed cryptography restrictions.");
                return true;
            }
            catch (Exception e) {
                logger.warn("Failed to remove cryptography restrictions.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean isRestrictedCryptography() {
        return "Java(TM) SE Runtime Environment".equals(System.getProperty("java.runtime.name"));
    }

    static {
        removed = CryptoRestrictions.removeCryptographyRestrictions();
    }
}

