/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="XVType")
public class XVType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.XVType;
    public static final NodeId BinaryEncodingId = Identifiers.XVType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.XVType_Encoding_DefaultXml;
    protected final Double _x;
    protected final Float _value;

    public XVType() {
        this._x = null;
        this._value = null;
    }

    public XVType(Double _x, Float _value) {
        this._x = _x;
        this._value = _value;
    }

    public Double getX() {
        return this._x;
    }

    public Float getValue() {
        return this._value;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("X", (Object)this._x).add("Value", (Object)this._value).toString();
    }

    public static void encode(XVType xVType, UaEncoder encoder) {
        encoder.encodeDouble("X", xVType._x);
        encoder.encodeFloat("Value", xVType._value);
    }

    public static XVType decode(UaDecoder decoder) {
        Double _x = decoder.decodeDouble("X");
        Float _value = decoder.decodeFloat("Value");
        return new XVType(_x, _value);
    }

    static {
        DelegateRegistry.registerEncoder(XVType::encode, XVType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(XVType::decode, XVType.class, BinaryEncodingId, XmlEncodingId);
    }
}

