/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

@UaDataType(value="ReadRawModifiedDetails")
public class ReadRawModifiedDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadRawModifiedDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadRawModifiedDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadRawModifiedDetails_Encoding_DefaultXml;
    protected final Boolean _isReadModified;
    protected final DateTime _startTime;
    protected final DateTime _endTime;
    protected final UInteger _numValuesPerNode;
    protected final Boolean _returnBounds;

    public ReadRawModifiedDetails() {
        this._isReadModified = null;
        this._startTime = null;
        this._endTime = null;
        this._numValuesPerNode = null;
        this._returnBounds = null;
    }

    public ReadRawModifiedDetails(Boolean _isReadModified, DateTime _startTime, DateTime _endTime, UInteger _numValuesPerNode, Boolean _returnBounds) {
        this._isReadModified = _isReadModified;
        this._startTime = _startTime;
        this._endTime = _endTime;
        this._numValuesPerNode = _numValuesPerNode;
        this._returnBounds = _returnBounds;
    }

    public Boolean getIsReadModified() {
        return this._isReadModified;
    }

    public DateTime getStartTime() {
        return this._startTime;
    }

    public DateTime getEndTime() {
        return this._endTime;
    }

    public UInteger getNumValuesPerNode() {
        return this._numValuesPerNode;
    }

    public Boolean getReturnBounds() {
        return this._returnBounds;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("IsReadModified", (Object)this._isReadModified).add("StartTime", (Object)this._startTime).add("EndTime", (Object)this._endTime).add("NumValuesPerNode", (Object)this._numValuesPerNode).add("ReturnBounds", (Object)this._returnBounds).toString();
    }

    public static void encode(ReadRawModifiedDetails readRawModifiedDetails, UaEncoder encoder) {
        encoder.encodeBoolean("IsReadModified", readRawModifiedDetails._isReadModified);
        encoder.encodeDateTime("StartTime", readRawModifiedDetails._startTime);
        encoder.encodeDateTime("EndTime", readRawModifiedDetails._endTime);
        encoder.encodeUInt32("NumValuesPerNode", readRawModifiedDetails._numValuesPerNode);
        encoder.encodeBoolean("ReturnBounds", readRawModifiedDetails._returnBounds);
    }

    public static ReadRawModifiedDetails decode(UaDecoder decoder) {
        Boolean _isReadModified = decoder.decodeBoolean("IsReadModified");
        DateTime _startTime = decoder.decodeDateTime("StartTime");
        DateTime _endTime = decoder.decodeDateTime("EndTime");
        UInteger _numValuesPerNode = decoder.decodeUInt32("NumValuesPerNode");
        Boolean _returnBounds = decoder.decodeBoolean("ReturnBounds");
        return new ReadRawModifiedDetails(_isReadModified, _startTime, _endTime, _numValuesPerNode, _returnBounds);
    }

    static {
        DelegateRegistry.registerEncoder(ReadRawModifiedDetails::encode, ReadRawModifiedDetails.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ReadRawModifiedDetails::decode, ReadRawModifiedDetails.class, BinaryEncodingId, XmlEncodingId);
    }
}

