/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

@UaDataType(value="ReadEventDetails")
public class ReadEventDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadEventDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadEventDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadEventDetails_Encoding_DefaultXml;
    protected final UInteger _numValuesPerNode;
    protected final DateTime _startTime;
    protected final DateTime _endTime;
    protected final EventFilter _filter;

    public ReadEventDetails() {
        this._numValuesPerNode = null;
        this._startTime = null;
        this._endTime = null;
        this._filter = null;
    }

    public ReadEventDetails(UInteger _numValuesPerNode, DateTime _startTime, DateTime _endTime, EventFilter _filter) {
        this._numValuesPerNode = _numValuesPerNode;
        this._startTime = _startTime;
        this._endTime = _endTime;
        this._filter = _filter;
    }

    public UInteger getNumValuesPerNode() {
        return this._numValuesPerNode;
    }

    public DateTime getStartTime() {
        return this._startTime;
    }

    public DateTime getEndTime() {
        return this._endTime;
    }

    public EventFilter getFilter() {
        return this._filter;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NumValuesPerNode", (Object)this._numValuesPerNode).add("StartTime", (Object)this._startTime).add("EndTime", (Object)this._endTime).add("Filter", (Object)this._filter).toString();
    }

    public static void encode(ReadEventDetails readEventDetails, UaEncoder encoder) {
        encoder.encodeUInt32("NumValuesPerNode", readEventDetails._numValuesPerNode);
        encoder.encodeDateTime("StartTime", readEventDetails._startTime);
        encoder.encodeDateTime("EndTime", readEventDetails._endTime);
        encoder.encodeSerializable("Filter", readEventDetails._filter != null ? readEventDetails._filter : new EventFilter());
    }

    public static ReadEventDetails decode(UaDecoder decoder) {
        UInteger _numValuesPerNode = decoder.decodeUInt32("NumValuesPerNode");
        DateTime _startTime = decoder.decodeDateTime("StartTime");
        DateTime _endTime = decoder.decodeDateTime("EndTime");
        EventFilter _filter = decoder.decodeSerializable("Filter", EventFilter.class);
        return new ReadEventDetails(_numValuesPerNode, _startTime, _endTime, _filter);
    }

    static {
        DelegateRegistry.registerEncoder(ReadEventDetails::encode, ReadEventDetails.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ReadEventDetails::decode, ReadEventDetails.class, BinaryEncodingId, XmlEncodingId);
    }
}

