/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

@UaDataType(value="ReadAtTimeDetails")
public class ReadAtTimeDetails
extends HistoryReadDetails {
    public static final NodeId TypeId = Identifiers.ReadAtTimeDetails;
    public static final NodeId BinaryEncodingId = Identifiers.ReadAtTimeDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ReadAtTimeDetails_Encoding_DefaultXml;
    protected final DateTime[] _reqTimes;
    protected final Boolean _useSimpleBounds;

    public ReadAtTimeDetails() {
        this._reqTimes = null;
        this._useSimpleBounds = null;
    }

    public ReadAtTimeDetails(DateTime[] _reqTimes, Boolean _useSimpleBounds) {
        this._reqTimes = _reqTimes;
        this._useSimpleBounds = _useSimpleBounds;
    }

    @Nullable
    public DateTime[] getReqTimes() {
        return this._reqTimes;
    }

    public Boolean getUseSimpleBounds() {
        return this._useSimpleBounds;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ReqTimes", (Object)this._reqTimes).add("UseSimpleBounds", (Object)this._useSimpleBounds).toString();
    }

    public static void encode(ReadAtTimeDetails readAtTimeDetails, UaEncoder encoder) {
        encoder.encodeArray("ReqTimes", readAtTimeDetails._reqTimes, encoder::encodeDateTime);
        encoder.encodeBoolean("UseSimpleBounds", readAtTimeDetails._useSimpleBounds);
    }

    public static ReadAtTimeDetails decode(UaDecoder decoder) {
        DateTime[] _reqTimes = decoder.decodeArray("ReqTimes", decoder::decodeDateTime, DateTime.class);
        Boolean _useSimpleBounds = decoder.decodeBoolean("UseSimpleBounds");
        return new ReadAtTimeDetails(_reqTimes, _useSimpleBounds);
    }

    static {
        DelegateRegistry.registerEncoder(ReadAtTimeDetails::encode, ReadAtTimeDetails.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(ReadAtTimeDetails::decode, ReadAtTimeDetails.class, BinaryEncodingId, XmlEncodingId);
    }
}

