/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

@UaDataType(value="OpenSecureChannelResponse")
public class OpenSecureChannelResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.OpenSecureChannelResponse;
    public static final NodeId BinaryEncodingId = Identifiers.OpenSecureChannelResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.OpenSecureChannelResponse_Encoding_DefaultXml;
    protected final ResponseHeader _responseHeader;
    protected final UInteger _serverProtocolVersion;
    protected final ChannelSecurityToken _securityToken;
    protected final ByteString _serverNonce;

    public OpenSecureChannelResponse() {
        this._responseHeader = null;
        this._serverProtocolVersion = null;
        this._securityToken = null;
        this._serverNonce = null;
    }

    public OpenSecureChannelResponse(ResponseHeader _responseHeader, UInteger _serverProtocolVersion, ChannelSecurityToken _securityToken, ByteString _serverNonce) {
        this._responseHeader = _responseHeader;
        this._serverProtocolVersion = _serverProtocolVersion;
        this._securityToken = _securityToken;
        this._serverNonce = _serverNonce;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this._responseHeader;
    }

    public UInteger getServerProtocolVersion() {
        return this._serverProtocolVersion;
    }

    public ChannelSecurityToken getSecurityToken() {
        return this._securityToken;
    }

    public ByteString getServerNonce() {
        return this._serverNonce;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this._responseHeader).add("ServerProtocolVersion", (Object)this._serverProtocolVersion).add("SecurityToken", (Object)this._securityToken).add("ServerNonce", (Object)this._serverNonce).toString();
    }

    public static void encode(OpenSecureChannelResponse openSecureChannelResponse, UaEncoder encoder) {
        encoder.encodeSerializable("ResponseHeader", openSecureChannelResponse._responseHeader != null ? openSecureChannelResponse._responseHeader : new ResponseHeader());
        encoder.encodeUInt32("ServerProtocolVersion", openSecureChannelResponse._serverProtocolVersion);
        encoder.encodeSerializable("SecurityToken", openSecureChannelResponse._securityToken != null ? openSecureChannelResponse._securityToken : new ChannelSecurityToken());
        encoder.encodeByteString("ServerNonce", openSecureChannelResponse._serverNonce);
    }

    public static OpenSecureChannelResponse decode(UaDecoder decoder) {
        ResponseHeader _responseHeader = decoder.decodeSerializable("ResponseHeader", ResponseHeader.class);
        UInteger _serverProtocolVersion = decoder.decodeUInt32("ServerProtocolVersion");
        ChannelSecurityToken _securityToken = decoder.decodeSerializable("SecurityToken", ChannelSecurityToken.class);
        ByteString _serverNonce = decoder.decodeByteString("ServerNonce");
        return new OpenSecureChannelResponse(_responseHeader, _serverProtocolVersion, _securityToken, _serverNonce);
    }

    static {
        DelegateRegistry.registerEncoder(OpenSecureChannelResponse::encode, OpenSecureChannelResponse.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(OpenSecureChannelResponse::decode, OpenSecureChannelResponse.class, BinaryEncodingId, XmlEncodingId);
    }
}

