/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="NotificationMessage")
public class NotificationMessage
implements UaStructure {
    public static final NodeId TypeId = Identifiers.NotificationMessage;
    public static final NodeId BinaryEncodingId = Identifiers.NotificationMessage_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.NotificationMessage_Encoding_DefaultXml;
    protected final UInteger _sequenceNumber;
    protected final DateTime _publishTime;
    protected final ExtensionObject[] _notificationData;

    public NotificationMessage() {
        this._sequenceNumber = null;
        this._publishTime = null;
        this._notificationData = null;
    }

    public NotificationMessage(UInteger _sequenceNumber, DateTime _publishTime, ExtensionObject[] _notificationData) {
        this._sequenceNumber = _sequenceNumber;
        this._publishTime = _publishTime;
        this._notificationData = _notificationData;
    }

    public UInteger getSequenceNumber() {
        return this._sequenceNumber;
    }

    public DateTime getPublishTime() {
        return this._publishTime;
    }

    @Nullable
    public ExtensionObject[] getNotificationData() {
        return this._notificationData;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SequenceNumber", (Object)this._sequenceNumber).add("PublishTime", (Object)this._publishTime).add("NotificationData", (Object)this._notificationData).toString();
    }

    public static void encode(NotificationMessage notificationMessage, UaEncoder encoder) {
        encoder.encodeUInt32("SequenceNumber", notificationMessage._sequenceNumber);
        encoder.encodeDateTime("PublishTime", notificationMessage._publishTime);
        encoder.encodeArray("NotificationData", notificationMessage._notificationData, encoder::encodeExtensionObject);
    }

    public static NotificationMessage decode(UaDecoder decoder) {
        UInteger _sequenceNumber = decoder.decodeUInt32("SequenceNumber");
        DateTime _publishTime = decoder.decodeDateTime("PublishTime");
        ExtensionObject[] _notificationData = decoder.decodeArray("NotificationData", decoder::decodeExtensionObject, ExtensionObject.class);
        return new NotificationMessage(_sequenceNumber, _publishTime, _notificationData);
    }

    static {
        DelegateRegistry.registerEncoder(NotificationMessage::encode, NotificationMessage.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(NotificationMessage::decode, NotificationMessage.class, BinaryEncodingId, XmlEncodingId);
    }
}

