/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataDescription;

@UaDataType(value="NodeTypeDescription")
public class NodeTypeDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.NodeTypeDescription;
    public static final NodeId BinaryEncodingId = Identifiers.NodeTypeDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.NodeTypeDescription_Encoding_DefaultXml;
    protected final ExpandedNodeId _typeDefinitionNode;
    protected final Boolean _includeSubTypes;
    protected final QueryDataDescription[] _dataToReturn;

    public NodeTypeDescription() {
        this._typeDefinitionNode = null;
        this._includeSubTypes = null;
        this._dataToReturn = null;
    }

    public NodeTypeDescription(ExpandedNodeId _typeDefinitionNode, Boolean _includeSubTypes, QueryDataDescription[] _dataToReturn) {
        this._typeDefinitionNode = _typeDefinitionNode;
        this._includeSubTypes = _includeSubTypes;
        this._dataToReturn = _dataToReturn;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this._typeDefinitionNode;
    }

    public Boolean getIncludeSubTypes() {
        return this._includeSubTypes;
    }

    @Nullable
    public QueryDataDescription[] getDataToReturn() {
        return this._dataToReturn;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("TypeDefinitionNode", (Object)this._typeDefinitionNode).add("IncludeSubTypes", (Object)this._includeSubTypes).add("DataToReturn", (Object)this._dataToReturn).toString();
    }

    public static void encode(NodeTypeDescription nodeTypeDescription, UaEncoder encoder) {
        encoder.encodeExpandedNodeId("TypeDefinitionNode", nodeTypeDescription._typeDefinitionNode);
        encoder.encodeBoolean("IncludeSubTypes", nodeTypeDescription._includeSubTypes);
        encoder.encodeArray("DataToReturn", nodeTypeDescription._dataToReturn, encoder::encodeSerializable);
    }

    public static NodeTypeDescription decode(UaDecoder decoder) {
        ExpandedNodeId _typeDefinitionNode = decoder.decodeExpandedNodeId("TypeDefinitionNode");
        Boolean _includeSubTypes = decoder.decodeBoolean("IncludeSubTypes");
        QueryDataDescription[] _dataToReturn = decoder.decodeArray("DataToReturn", decoder::decodeSerializable, QueryDataDescription.class);
        return new NodeTypeDescription(_typeDefinitionNode, _includeSubTypes, _dataToReturn);
    }

    static {
        DelegateRegistry.registerEncoder(NodeTypeDescription::encode, NodeTypeDescription.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(NodeTypeDescription::decode, NodeTypeDescription.class, BinaryEncodingId, XmlEncodingId);
    }
}

