/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointUrlListDataType;

@UaDataType(value="NetworkGroupDataType")
public class NetworkGroupDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.NetworkGroupDataType;
    public static final NodeId BinaryEncodingId = Identifiers.NetworkGroupDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.NetworkGroupDataType_Encoding_DefaultXml;
    protected final String _serverUri;
    protected final EndpointUrlListDataType[] _networkPaths;

    public NetworkGroupDataType() {
        this._serverUri = null;
        this._networkPaths = null;
    }

    public NetworkGroupDataType(String _serverUri, EndpointUrlListDataType[] _networkPaths) {
        this._serverUri = _serverUri;
        this._networkPaths = _networkPaths;
    }

    public String getServerUri() {
        return this._serverUri;
    }

    @Nullable
    public EndpointUrlListDataType[] getNetworkPaths() {
        return this._networkPaths;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ServerUri", (Object)this._serverUri).add("NetworkPaths", (Object)this._networkPaths).toString();
    }

    public static void encode(NetworkGroupDataType networkGroupDataType, UaEncoder encoder) {
        encoder.encodeString("ServerUri", networkGroupDataType._serverUri);
        encoder.encodeArray("NetworkPaths", networkGroupDataType._networkPaths, encoder::encodeSerializable);
    }

    public static NetworkGroupDataType decode(UaDecoder decoder) {
        String _serverUri = decoder.decodeString("ServerUri");
        EndpointUrlListDataType[] _networkPaths = decoder.decodeArray("NetworkPaths", decoder::decodeSerializable, EndpointUrlListDataType.class);
        return new NetworkGroupDataType(_serverUri, _networkPaths);
    }

    static {
        DelegateRegistry.registerEncoder(NetworkGroupDataType::encode, NetworkGroupDataType.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(NetworkGroupDataType::decode, NetworkGroupDataType.class, BinaryEncodingId, XmlEncodingId);
    }
}

