/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="MonitoringParameters")
public class MonitoringParameters
implements UaStructure {
    public static final NodeId TypeId = Identifiers.MonitoringParameters;
    public static final NodeId BinaryEncodingId = Identifiers.MonitoringParameters_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MonitoringParameters_Encoding_DefaultXml;
    protected final UInteger _clientHandle;
    protected final Double _samplingInterval;
    protected final ExtensionObject _filter;
    protected final UInteger _queueSize;
    protected final Boolean _discardOldest;

    public MonitoringParameters() {
        this._clientHandle = null;
        this._samplingInterval = null;
        this._filter = null;
        this._queueSize = null;
        this._discardOldest = null;
    }

    public MonitoringParameters(UInteger _clientHandle, Double _samplingInterval, ExtensionObject _filter, UInteger _queueSize, Boolean _discardOldest) {
        this._clientHandle = _clientHandle;
        this._samplingInterval = _samplingInterval;
        this._filter = _filter;
        this._queueSize = _queueSize;
        this._discardOldest = _discardOldest;
    }

    public UInteger getClientHandle() {
        return this._clientHandle;
    }

    public Double getSamplingInterval() {
        return this._samplingInterval;
    }

    public ExtensionObject getFilter() {
        return this._filter;
    }

    public UInteger getQueueSize() {
        return this._queueSize;
    }

    public Boolean getDiscardOldest() {
        return this._discardOldest;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ClientHandle", (Object)this._clientHandle).add("SamplingInterval", (Object)this._samplingInterval).add("Filter", (Object)this._filter).add("QueueSize", (Object)this._queueSize).add("DiscardOldest", (Object)this._discardOldest).toString();
    }

    public static void encode(MonitoringParameters monitoringParameters, UaEncoder encoder) {
        encoder.encodeUInt32("ClientHandle", monitoringParameters._clientHandle);
        encoder.encodeDouble("SamplingInterval", monitoringParameters._samplingInterval);
        encoder.encodeExtensionObject("Filter", monitoringParameters._filter);
        encoder.encodeUInt32("QueueSize", monitoringParameters._queueSize);
        encoder.encodeBoolean("DiscardOldest", monitoringParameters._discardOldest);
    }

    public static MonitoringParameters decode(UaDecoder decoder) {
        UInteger _clientHandle = decoder.decodeUInt32("ClientHandle");
        Double _samplingInterval = decoder.decodeDouble("SamplingInterval");
        ExtensionObject _filter = decoder.decodeExtensionObject("Filter");
        UInteger _queueSize = decoder.decodeUInt32("QueueSize");
        Boolean _discardOldest = decoder.decodeBoolean("DiscardOldest");
        return new MonitoringParameters(_clientHandle, _samplingInterval, _filter, _queueSize, _discardOldest);
    }

    static {
        DelegateRegistry.registerEncoder(MonitoringParameters::encode, MonitoringParameters.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(MonitoringParameters::decode, MonitoringParameters.class, BinaryEncodingId, XmlEncodingId);
    }
}

