/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DiscoveryConfiguration;

@UaDataType(value="MdnsDiscoveryConfiguration")
public class MdnsDiscoveryConfiguration
extends DiscoveryConfiguration {
    public static final NodeId TypeId = Identifiers.MdnsDiscoveryConfiguration;
    public static final NodeId BinaryEncodingId = Identifiers.MdnsDiscoveryConfiguration_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.MdnsDiscoveryConfiguration_Encoding_DefaultXml;
    protected final String _mdnsServerName;
    protected final String[] _serverCapabilities;

    public MdnsDiscoveryConfiguration() {
        this._mdnsServerName = null;
        this._serverCapabilities = null;
    }

    public MdnsDiscoveryConfiguration(String _mdnsServerName, String[] _serverCapabilities) {
        this._mdnsServerName = _mdnsServerName;
        this._serverCapabilities = _serverCapabilities;
    }

    public String getMdnsServerName() {
        return this._mdnsServerName;
    }

    @Nullable
    public String[] getServerCapabilities() {
        return this._serverCapabilities;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("MdnsServerName", (Object)this._mdnsServerName).add("ServerCapabilities", (Object)this._serverCapabilities).toString();
    }

    public static void encode(MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration, UaEncoder encoder) {
        encoder.encodeString("MdnsServerName", mdnsDiscoveryConfiguration._mdnsServerName);
        encoder.encodeArray("ServerCapabilities", mdnsDiscoveryConfiguration._serverCapabilities, encoder::encodeString);
    }

    public static MdnsDiscoveryConfiguration decode(UaDecoder decoder) {
        String _mdnsServerName = decoder.decodeString("MdnsServerName");
        String[] _serverCapabilities = decoder.decodeArray("ServerCapabilities", decoder::decodeString, String.class);
        return new MdnsDiscoveryConfiguration(_mdnsServerName, _serverCapabilities);
    }

    static {
        DelegateRegistry.registerEncoder(MdnsDiscoveryConfiguration::encode, MdnsDiscoveryConfiguration.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(MdnsDiscoveryConfiguration::decode, MdnsDiscoveryConfiguration.class, BinaryEncodingId, XmlEncodingId);
    }
}

