/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

@UaDataType(value="KerberosIdentityToken")
public class KerberosIdentityToken
extends UserIdentityToken {
    public static final NodeId TypeId = Identifiers.KerberosIdentityToken;
    public static final NodeId BinaryEncodingId = Identifiers.KerberosIdentityToken_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.KerberosIdentityToken_Encoding_DefaultXml;
    protected final ByteString _ticketData;

    public KerberosIdentityToken() {
        super(null);
        this._ticketData = null;
    }

    public KerberosIdentityToken(String _policyId, ByteString _ticketData) {
        super(_policyId);
        this._ticketData = _ticketData;
    }

    public ByteString getTicketData() {
        return this._ticketData;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("PolicyId", (Object)this._policyId).add("TicketData", (Object)this._ticketData).toString();
    }

    public static void encode(KerberosIdentityToken kerberosIdentityToken, UaEncoder encoder) {
        encoder.encodeString("PolicyId", kerberosIdentityToken._policyId);
        encoder.encodeByteString("TicketData", kerberosIdentityToken._ticketData);
    }

    public static KerberosIdentityToken decode(UaDecoder decoder) {
        String _policyId = decoder.decodeString("PolicyId");
        ByteString _ticketData = decoder.decodeByteString("TicketData");
        return new KerberosIdentityToken(_policyId, _ticketData);
    }

    static {
        DelegateRegistry.registerEncoder(KerberosIdentityToken::encode, KerberosIdentityToken.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(KerberosIdentityToken::decode, KerberosIdentityToken.class, BinaryEncodingId, XmlEncodingId);
    }
}

