/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

@UaDataType(value="FindServersOnNetworkRequest")
public class FindServersOnNetworkRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.FindServersOnNetworkRequest;
    public static final NodeId BinaryEncodingId = Identifiers.FindServersOnNetworkRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.FindServersOnNetworkRequest_Encoding_DefaultXml;
    protected final RequestHeader _requestHeader;
    protected final UInteger _startingRecordId;
    protected final UInteger _maxRecordsToReturn;
    protected final String[] _serverCapabilityFilter;

    public FindServersOnNetworkRequest() {
        this._requestHeader = null;
        this._startingRecordId = null;
        this._maxRecordsToReturn = null;
        this._serverCapabilityFilter = null;
    }

    public FindServersOnNetworkRequest(RequestHeader _requestHeader, UInteger _startingRecordId, UInteger _maxRecordsToReturn, String[] _serverCapabilityFilter) {
        this._requestHeader = _requestHeader;
        this._startingRecordId = _startingRecordId;
        this._maxRecordsToReturn = _maxRecordsToReturn;
        this._serverCapabilityFilter = _serverCapabilityFilter;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this._requestHeader;
    }

    public UInteger getStartingRecordId() {
        return this._startingRecordId;
    }

    public UInteger getMaxRecordsToReturn() {
        return this._maxRecordsToReturn;
    }

    @Nullable
    public String[] getServerCapabilityFilter() {
        return this._serverCapabilityFilter;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this._requestHeader).add("StartingRecordId", (Object)this._startingRecordId).add("MaxRecordsToReturn", (Object)this._maxRecordsToReturn).add("ServerCapabilityFilter", (Object)this._serverCapabilityFilter).toString();
    }

    public static void encode(FindServersOnNetworkRequest findServersOnNetworkRequest, UaEncoder encoder) {
        encoder.encodeSerializable("RequestHeader", findServersOnNetworkRequest._requestHeader != null ? findServersOnNetworkRequest._requestHeader : new RequestHeader());
        encoder.encodeUInt32("StartingRecordId", findServersOnNetworkRequest._startingRecordId);
        encoder.encodeUInt32("MaxRecordsToReturn", findServersOnNetworkRequest._maxRecordsToReturn);
        encoder.encodeArray("ServerCapabilityFilter", findServersOnNetworkRequest._serverCapabilityFilter, encoder::encodeString);
    }

    public static FindServersOnNetworkRequest decode(UaDecoder decoder) {
        RequestHeader _requestHeader = decoder.decodeSerializable("RequestHeader", RequestHeader.class);
        UInteger _startingRecordId = decoder.decodeUInt32("StartingRecordId");
        UInteger _maxRecordsToReturn = decoder.decodeUInt32("MaxRecordsToReturn");
        String[] _serverCapabilityFilter = decoder.decodeArray("ServerCapabilityFilter", decoder::decodeString, String.class);
        return new FindServersOnNetworkRequest(_requestHeader, _startingRecordId, _maxRecordsToReturn, _serverCapabilityFilter);
    }

    static {
        DelegateRegistry.registerEncoder(FindServersOnNetworkRequest::encode, FindServersOnNetworkRequest.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(FindServersOnNetworkRequest::decode, FindServersOnNetworkRequest.class, BinaryEncodingId, XmlEncodingId);
    }
}

