/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilterResult;

@UaDataType(value="EventFilterResult")
public class EventFilterResult
extends MonitoringFilterResult {
    public static final NodeId TypeId = Identifiers.EventFilterResult;
    public static final NodeId BinaryEncodingId = Identifiers.EventFilterResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventFilterResult_Encoding_DefaultXml;
    protected final StatusCode[] _selectClauseResults;
    protected final DiagnosticInfo[] _selectClauseDiagnosticInfos;
    protected final ContentFilterResult _whereClauseResult;

    public EventFilterResult() {
        this._selectClauseResults = null;
        this._selectClauseDiagnosticInfos = null;
        this._whereClauseResult = null;
    }

    public EventFilterResult(StatusCode[] _selectClauseResults, DiagnosticInfo[] _selectClauseDiagnosticInfos, ContentFilterResult _whereClauseResult) {
        this._selectClauseResults = _selectClauseResults;
        this._selectClauseDiagnosticInfos = _selectClauseDiagnosticInfos;
        this._whereClauseResult = _whereClauseResult;
    }

    @Nullable
    public StatusCode[] getSelectClauseResults() {
        return this._selectClauseResults;
    }

    @Nullable
    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this._selectClauseDiagnosticInfos;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this._whereClauseResult;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SelectClauseResults", (Object)this._selectClauseResults).add("SelectClauseDiagnosticInfos", (Object)this._selectClauseDiagnosticInfos).add("WhereClauseResult", (Object)this._whereClauseResult).toString();
    }

    public static void encode(EventFilterResult eventFilterResult, UaEncoder encoder) {
        encoder.encodeArray("SelectClauseResults", eventFilterResult._selectClauseResults, encoder::encodeStatusCode);
        encoder.encodeArray("SelectClauseDiagnosticInfos", eventFilterResult._selectClauseDiagnosticInfos, encoder::encodeDiagnosticInfo);
        encoder.encodeSerializable("WhereClauseResult", eventFilterResult._whereClauseResult != null ? eventFilterResult._whereClauseResult : new ContentFilterResult());
    }

    public static EventFilterResult decode(UaDecoder decoder) {
        StatusCode[] _selectClauseResults = decoder.decodeArray("SelectClauseResults", decoder::decodeStatusCode, StatusCode.class);
        DiagnosticInfo[] _selectClauseDiagnosticInfos = decoder.decodeArray("SelectClauseDiagnosticInfos", decoder::decodeDiagnosticInfo, DiagnosticInfo.class);
        ContentFilterResult _whereClauseResult = decoder.decodeSerializable("WhereClauseResult", ContentFilterResult.class);
        return new EventFilterResult(_selectClauseResults, _selectClauseDiagnosticInfos, _whereClauseResult);
    }

    static {
        DelegateRegistry.registerEncoder(EventFilterResult::encode, EventFilterResult.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(EventFilterResult::decode, EventFilterResult.class, BinaryEncodingId, XmlEncodingId);
    }
}

