/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

@UaDataType(value="EventFilter")
public class EventFilter
extends MonitoringFilter {
    public static final NodeId TypeId = Identifiers.EventFilter;
    public static final NodeId BinaryEncodingId = Identifiers.EventFilter_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventFilter_Encoding_DefaultXml;
    protected final SimpleAttributeOperand[] _selectClauses;
    protected final ContentFilter _whereClause;

    public EventFilter() {
        this._selectClauses = null;
        this._whereClause = null;
    }

    public EventFilter(SimpleAttributeOperand[] _selectClauses, ContentFilter _whereClause) {
        this._selectClauses = _selectClauses;
        this._whereClause = _whereClause;
    }

    @Nullable
    public SimpleAttributeOperand[] getSelectClauses() {
        return this._selectClauses;
    }

    public ContentFilter getWhereClause() {
        return this._whereClause;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SelectClauses", (Object)this._selectClauses).add("WhereClause", (Object)this._whereClause).toString();
    }

    public static void encode(EventFilter eventFilter, UaEncoder encoder) {
        encoder.encodeArray("SelectClauses", eventFilter._selectClauses, encoder::encodeSerializable);
        encoder.encodeSerializable("WhereClause", eventFilter._whereClause != null ? eventFilter._whereClause : new ContentFilter());
    }

    public static EventFilter decode(UaDecoder decoder) {
        SimpleAttributeOperand[] _selectClauses = decoder.decodeArray("SelectClauses", decoder::decodeSerializable, SimpleAttributeOperand.class);
        ContentFilter _whereClause = decoder.decodeSerializable("WhereClause", ContentFilter.class);
        return new EventFilter(_selectClauses, _whereClause);
    }

    static {
        DelegateRegistry.registerEncoder(EventFilter::encode, EventFilter.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(EventFilter::decode, EventFilter.class, BinaryEncodingId, XmlEncodingId);
    }
}

