/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaDataType(value="EventFieldList")
public class EventFieldList
implements UaStructure {
    public static final NodeId TypeId = Identifiers.EventFieldList;
    public static final NodeId BinaryEncodingId = Identifiers.EventFieldList_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventFieldList_Encoding_DefaultXml;
    protected final UInteger _clientHandle;
    protected final Variant[] _eventFields;

    public EventFieldList() {
        this._clientHandle = null;
        this._eventFields = null;
    }

    public EventFieldList(UInteger _clientHandle, Variant[] _eventFields) {
        this._clientHandle = _clientHandle;
        this._eventFields = _eventFields;
    }

    public UInteger getClientHandle() {
        return this._clientHandle;
    }

    @Nullable
    public Variant[] getEventFields() {
        return this._eventFields;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ClientHandle", (Object)this._clientHandle).add("EventFields", (Object)this._eventFields).toString();
    }

    public static void encode(EventFieldList eventFieldList, UaEncoder encoder) {
        encoder.encodeUInt32("ClientHandle", eventFieldList._clientHandle);
        encoder.encodeArray("EventFields", eventFieldList._eventFields, encoder::encodeVariant);
    }

    public static EventFieldList decode(UaDecoder decoder) {
        UInteger _clientHandle = decoder.decodeUInt32("ClientHandle");
        Variant[] _eventFields = decoder.decodeArray("EventFields", decoder::decodeVariant, Variant.class);
        return new EventFieldList(_clientHandle, _eventFields);
    }

    static {
        DelegateRegistry.registerEncoder(EventFieldList::encode, EventFieldList.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(EventFieldList::decode, EventFieldList.class, BinaryEncodingId, XmlEncodingId);
    }
}

