/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

@UaDataType(value="EUInformation")
public class EUInformation
implements UaStructure {
    public static final NodeId TypeId = Identifiers.EUInformation;
    public static final NodeId BinaryEncodingId = Identifiers.EUInformation_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EUInformation_Encoding_DefaultXml;
    protected final String _namespaceUri;
    protected final Integer _unitId;
    protected final LocalizedText _displayName;
    protected final LocalizedText _description;

    public EUInformation() {
        this._namespaceUri = null;
        this._unitId = null;
        this._displayName = null;
        this._description = null;
    }

    public EUInformation(String _namespaceUri, Integer _unitId, LocalizedText _displayName, LocalizedText _description) {
        this._namespaceUri = _namespaceUri;
        this._unitId = _unitId;
        this._displayName = _displayName;
        this._description = _description;
    }

    public String getNamespaceUri() {
        return this._namespaceUri;
    }

    public Integer getUnitId() {
        return this._unitId;
    }

    public LocalizedText getDisplayName() {
        return this._displayName;
    }

    public LocalizedText getDescription() {
        return this._description;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NamespaceUri", (Object)this._namespaceUri).add("UnitId", (Object)this._unitId).add("DisplayName", (Object)this._displayName).add("Description", (Object)this._description).toString();
    }

    public static void encode(EUInformation eUInformation, UaEncoder encoder) {
        encoder.encodeString("NamespaceUri", eUInformation._namespaceUri);
        encoder.encodeInt32("UnitId", eUInformation._unitId);
        encoder.encodeLocalizedText("DisplayName", eUInformation._displayName);
        encoder.encodeLocalizedText("Description", eUInformation._description);
    }

    public static EUInformation decode(UaDecoder decoder) {
        String _namespaceUri = decoder.decodeString("NamespaceUri");
        Integer _unitId = decoder.decodeInt32("UnitId");
        LocalizedText _displayName = decoder.decodeLocalizedText("DisplayName");
        LocalizedText _description = decoder.decodeLocalizedText("Description");
        return new EUInformation(_namespaceUri, _unitId, _displayName, _description);
    }

    static {
        DelegateRegistry.registerEncoder(EUInformation::encode, EUInformation.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(EUInformation::decode, EUInformation.class, BinaryEncodingId, XmlEncodingId);
    }
}

