/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.DelegateRegistry;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.types.UaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

@UaDataType(value="DeleteRawModifiedDetails")
public class DeleteRawModifiedDetails
extends HistoryUpdateDetails {
    public static final NodeId TypeId = Identifiers.DeleteRawModifiedDetails;
    public static final NodeId BinaryEncodingId = Identifiers.DeleteRawModifiedDetails_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.DeleteRawModifiedDetails_Encoding_DefaultXml;
    protected final Boolean _isDeleteModified;
    protected final DateTime _startTime;
    protected final DateTime _endTime;

    public DeleteRawModifiedDetails() {
        super(null);
        this._isDeleteModified = null;
        this._startTime = null;
        this._endTime = null;
    }

    public DeleteRawModifiedDetails(NodeId _nodeId, Boolean _isDeleteModified, DateTime _startTime, DateTime _endTime) {
        super(_nodeId);
        this._isDeleteModified = _isDeleteModified;
        this._startTime = _startTime;
        this._endTime = _endTime;
    }

    public Boolean getIsDeleteModified() {
        return this._isDeleteModified;
    }

    public DateTime getStartTime() {
        return this._startTime;
    }

    public DateTime getEndTime() {
        return this._endTime;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this._nodeId).add("IsDeleteModified", (Object)this._isDeleteModified).add("StartTime", (Object)this._startTime).add("EndTime", (Object)this._endTime).toString();
    }

    public static void encode(DeleteRawModifiedDetails deleteRawModifiedDetails, UaEncoder encoder) {
        encoder.encodeNodeId("NodeId", deleteRawModifiedDetails._nodeId);
        encoder.encodeBoolean("IsDeleteModified", deleteRawModifiedDetails._isDeleteModified);
        encoder.encodeDateTime("StartTime", deleteRawModifiedDetails._startTime);
        encoder.encodeDateTime("EndTime", deleteRawModifiedDetails._endTime);
    }

    public static DeleteRawModifiedDetails decode(UaDecoder decoder) {
        NodeId _nodeId = decoder.decodeNodeId("NodeId");
        Boolean _isDeleteModified = decoder.decodeBoolean("IsDeleteModified");
        DateTime _startTime = decoder.decodeDateTime("StartTime");
        DateTime _endTime = decoder.decodeDateTime("EndTime");
        return new DeleteRawModifiedDetails(_nodeId, _isDeleteModified, _startTime, _endTime);
    }

    static {
        DelegateRegistry.registerEncoder(DeleteRawModifiedDetails::encode, DeleteRawModifiedDetails.class, BinaryEncodingId, XmlEncodingId);
        DelegateRegistry.registerDecoder(DeleteRawModifiedDetails::decode, DeleteRawModifiedDetails.class, BinaryEncodingId, XmlEncodingId);
    }
}

